function CRSColorZeroCal(prompt)
% CRSColorZeroCal([prompt])
%
% prompt == 0 -- no user prompt.
% prompt == 1 -- wait for user (default).
%
% 2/27/03 	jb, eh	Wrote it.
% 03/08/03 dhb			GetClicks should come before command write, not after.
%          dhb  		Extend error checking.
%          dhb    	Control whether or not there is a user prompt.

% Report information from the CRS meter, obtained with the IDR command.
global crsColorInfo

% Set default value for prompt
if (nargin < 1 | isempty(prompt))
	prompt = 1;
end

% Set up command.
cmd = '                                ';
cmd(1:3) = 'UZC';
cmd(4) = char(10);

% Wait for user
if (prompt)
	fprintf('Press the CRS meter against the desk. Click mouse to continue.\n');
	GetClicks;
end

% Write the command
PSYCHSERIAL('Write',crsColorInfo,cmd);

% Read Response
rawResponse = PSYCHSERIAL('ReadRaw',crsColorInfo,32);
if strncmp(rawResponse,'ER',2)
	fprintf('Response to UZC command was: %s\n',rawResponse);
	error('Error during CRSColorZeroCal');
elseif strncmp(rawResponse,'OK',2)
	fprintf('CRSColorZeroCal: success!\n');	
else
	fprintf('Response to UZC command was: %s\n',rawResponse);
	error('Error during CRSColorZeroCal');
end
