function [retval] = PR650init(portNameIn,portNameOut)
% [retval] = PR650init(portNameIn,portNameOut)
% 
% Initialize serial port for talking to colorimeter.
% Returns whatever character is sent by colorimeter
% in response to a 'b3' command.
%
% 4/4/00  dhb, jdt  Add comments, port argument.
% 1/10/02 dhb, ly   Pass both in and out portnames, now required.
% 2/15/02 dhb       Change name.
 
global infoC

% Only open if we haven't already.
if (isempty(infoC))
   infoC = PsychSerial('Open',portNameIn,portNameOut,9600);
   PsychSerial('Close',infoC);
   WaitSecs(0.5);
   infoC = PsychSerial('Open',portNameIn,portNameOut,9600);
end

% Send set backlight command to high level to check
% whether we are talking to the meter.
PsychSerial('Write',infoC,['b3' char(10)]);
retval = PsychSerial('Read',infoC);
