function PR650setsyncfreq(syncFreq)
% PR650setsyncfreq(syncFreq)
%
% Set sync frequency for source.  Passing
% 1 means use last sync measurement.
%
% See also PR650getsyncfreq
%
% 2/15/02  dhb  Wrote it.

% Global storage
global infoC

% Check for initialization
if (isempty(infoC))
   error('Meter has not been initialized.');
end

% Initialize
timeout = 30;

% Flushing buffers.
% fprintf('Flush\n');
dumpStr = '0';
while (~isempty(dumpStr))
	dumpStr = PsychSerial('Read',infoC);
end

% Set
if (syncFreq ~= 0)
	PsychSerial('Write',infoC,['s01,,,,' num2str(syncFreq) ',0,01,1' char(10)]);
else
	PsychSerial('Write',infoC,['s01,,,,' ',0,01,1' char(10)]);
end

waited = 0;
inStr =[];
while ((isempty(inStr))& (waited<timeout))
	WaitSecs(1);
	waited = waited+1;
	inStr = PsychSerial('Read',infoC);
end
if (waited == timeout)
	error('No response after measure command');
end

% Pick up entire buffer.  This is the loop referred to above.
readStr = inStr;
while (~isempty(inStr))
	inStr = PsychSerial('Read',infoC);
	readStr = [readStr inStr];
end

% Parse return
qual = sscanf(readStr,'%f',1);
if (qual ~= 0)
	fprintf('Return string was %s\n',readStr);
	error('Can''t set parameters');
end
