function T = AdjustForSelfScreening(T,c,h)
% T = AdjustForSelfScreening(T,c,h)
%
% Adjust quantal absorption curves for self-screening.
%   c - specific density
%   h - pigment thickness layer
%
% Passing NaN for either parameter causes this routine
% simply to pass its input to its output.
%
% Formula similar to page 588 of W+S, 2cd edition,
% except that we use base 10 rather than base e.
% A reasonable number for the concentration is
%   c = 0.016 (/m)
%
% 3/23/99  dhb  Wrote it.
% 6/10/99  dhb  Passing NaN skips the correction.
%
% Obsolete: Use AbsorbanceToAbsorbtance instead, passing product c*h as OD.

if (isnan(c) | isnan(h))
else
	T = 1 - 10.^(-c*h*T);
end
