function FS
% status = FS('Command')
%
% MEX file to control filesharing.  This routine is primarily
% intended to be called at the start of experiments to turn
% filesharing off and at the end to turn it back on again.  You
% really don't want filesharing running when you are doing anything
% where timing matters.
%
% status = FS('Check')
%   -3 if filesharing is off or not supported.
%   -2 if it is starting up.
%   -1 if it is on.
%    n number of minutes to shut down, where n > 0.
%
% status = FS('Off')
%   Turn filesharing off.  Variable status is as follows:
%		  0  = no error (turned off, was off, or no filesharing).
%
% status = FS('On')
%	  Turn filesharing on.  Variable status is as follows:
%     0  = no error (file sharing turned on or was on).
%    -1  = no file sharing supported, can't turn on.
%
% CAUTION: When writing programs that other people may use,
% we suggest asking for permission to turn off filesharing
% before doing so. Someone may run your program on an important
% file server. See ScreenTest.m as an example.
%
% NOTE: We have only tested this routine with Filesharing (the stuff
% that comes standard with the Mac OS, not with Appleshare (the
% server software you can buy separately.)  It should work with
% Appleshare, but there are some message pointers that are
% irrelevant with Filesharing that may matter with Appleshare.
% We think we set them up properly, but we couldn't test it.  In
% any case, if you're running experiments on a machine with 
% Appleshare running, you should probably rethink what you are 
% doing.
%
% See also FileShare, which provides a nicer interface to FS.

% 7/2/95    dhb   Wrote it.
% 2/9/96    dhb   Re-wrote and added turning on feature.
% 3/20/97   dhb   More complete status reporting, other status mods.
% 6/3/97	dgp   Updated
