function is = IsATIRadeon10(windowPtrOrScreenNumber)
% is = IsATIRadeon10(windowPtrOrScreenNumber)
% 
% Reads card and driver names to determine whether the card is an ATI
% Radeon (aka "DualHead") card with 10-bit DACs with a driver that can use
% them. The answer is cached the first time this is called, so that
% subsequent calls are fast.
% 
% An OEM Radeon with MacOS 9.2.1 drivers (version 1.0b25) or a Retail
% Radeon with the September ROM Update (version 1.0f52) should work. The
% ROM update is at
% <http://support.atitech.ca/drivers/mac/ati_mac_rom_901.html>
% 
% IMPORTANT: Please try to avoid calling this routine directly. That would
% make your software platform specific, which is something we are trying
% to avoid. If you want to know your driver's DAC size (8, 9, or 10 bits)
% or how to align the bits in the gamma table then call ScreenDacBits or
% ScreenUsesHighGammaBits.

% 10/3/01  bds  Wrote it, nearly identical to IsRadius by dhb.
% 1/25/02  dhb	Add check for driver 1.0f49, which is what came with 9.2.1 on my G4 towers.
% 3/10/02  dhb  Add check for driver versions 1.0f57 and 1.0f58
% 3/20/02  dgp	Cosmetic.
% 6/6/02   dgp	Renamed IsATIRadeon10.
% 6/20/02  dgp	Streamlined. Only compute for screens that the user asks about.
% 6/29/02  dgp  Use new version of Screen VideoCard.

global ATIRadeon10; % Cache answers for future reference.

% Set up static information on first call.
if isempty(ATIRadeon10)
	ATIRadeon10 = NaN*Screen('Screens');
end
s=Screen(windowPtrOrScreenNumber,'WindowScreenNumber')+1;
if s<1
	error('Passed windowPtrOrScreenNumber does not correspond to an installed screen.');
end
if isnan(ATIRadeon10(s))
	card=Screen(windowPtrOrScreenNumber,'VideoCard');
	oem = 'ATY,Rage6';
	retail = 'ATY,RADEON';
	isOEM = ~isempty(findstr(card.cardName,oem));
	isRetail = ~isempty(findstr(card.cardName,retail));
	isOS921_1 = strcmp(card.driverVersion,'1.0b25');
	isOS921_2 = strcmp(card.driverVersion,'1.0f49');
	isOS922_1 = strcmp(card.driverVersion,'1.0f58');
	isOS921 = isOS921_1 | isOS921_2 | isOS922_1;
	isSeptUpdate = strcmp(card.driverVersion,'1.0f52');
	isJanUpdate = strcmp(card.driverVersion,'1.0f57');
	ATIRadeon10(s) = (isOEM & isOS921) | ((isOEM | isRetail) & (isSeptUpdate | isJanUpdate));
end
is = ATIRadeon10(s);
