function is = IsATIRadeon10Gen2(windowPtrOrScreenNumber)
% is = IsATIRadeon10Gen2(windowPtrOrScreenNumber)
%
% Reads card name to determine whether the card is a 2nd generation Radeon
% 10-bit card with a driver that can use the 10 bits.  This is used to
% determine how to write the CLUT ('SetClut' or 'Gamma').
% 
% The answer is cached the first time this is called, so that subsequent
% calls are fast.
% 
% We expect IsATIRadeon10Gen2 to be true for a strict subset of
% the cards for which IsATIRadeon10 is true. However, IsATIRadeon10Gen2 is based on
% card names while IsATIRadeon10 is based on driver versions, so our expectation
% isn't a foregone conclusion. Thus IsATIRadeon10 | IsATIRadeon10Gen2 may
% not be equivalent to IsATIRadeon10 in all cases.
% 
% IMPORTANT: Please try to avoid calling this routine directly. That would
% make your software platform specific, which is something we are trying
% to avoid. If you want to know your driver's DAC size (8, 9, or 10 bits)
% or how to align the bits in the gamma table then call ScreenDacBits or
% ScreenUsesHighGammaBits.

% 3/15/02  bds  wrote it, based on IsATIRadeon10.m
% 4/2/02   bds	tested on Radeon 7500 successfully!
% 6/5/02   dgp  Renamed IsATIRadeon10Gen2. Added code for 8500. 
% 6/20/02  dgp	Streamlined. Only compute for screens that the user asks about.
% 6/29/02  dgp  Use new version of Screen VideoCard.

global ATIRadeon10Gen2 % Cache answers for future reference.

% Set up static information on first call.
if isempty(ATIRadeon10Gen2)
	ATIRadeon10Gen2 = NaN*Screen('Screens');
end
s=Screen(windowPtrOrScreenNumber,'WindowScreenNumber')+1;
if s<1
	error('Passed windowPtrOrScreenNumber does not correspond to an installed screen.');
end
% Set up static information on first call.
if isnan(ATIRadeon10Gen2(s))
	card=Screen(windowPtrOrScreenNumber,'VideoCard');
	is7000 = strcmp(card.cardName,'ATY,RV100ad_A') | strcmp(card.cardName,'ATY,RV100ad_B');
	is7500 = strcmp(card.cardName,'ATY,BlueStone_A') | strcmp(card.cardName,'ATY,BlueStone_B');
	is8500 = strcmp(card.cardName,'ATY,R200i_A') | strcmp(card.cardName,'ATY,R200i_B');
	ATIRadeon10Gen2(s) = is7000 | is7500 | is8500;
end
is = ATIRadeon10Gen2(s);
