function is = IsATIRadeon7000(windowPtrOrScreenNumber)
% is = IsATIRadeon7000(windowPtrOrScreenNumber)
% 
% Reads card and driver names to determine whether the card is an ATI
% Radeon (aka "DualHead") 7000 card. This card has 10-bit DACs and a
% driver that can use them. The answer for each screen is cached,
% so that subsequent calls are fast.
% 
% IMPORTANT: Please try to avoid calling this routine directly. That would
% make your software platform specific, which is something we are trying
% to avoid. If you want to know your driver's DAC size (8, 9, or 10 bits)
% or how to align the bits in the gamma table then call ScreenDacBits or
% ScreenUsesHighGammaBits.

% 6/22/02  dgp	Wrote it, based on IsATIRadeon10.m
% 6/29/02  dgp  Use new version of Screen VideoCard.

global ATIRadeon7000; % Cache answers for future reference.

% Set up static information on first call.
if isempty(ATIRadeon7000)
	ATIRadeon7000 = NaN*Screen('Screens');
end
s=Screen(windowPtrOrScreenNumber,'WindowScreenNumber')+1;
if s<1
	error('Passed windowPtrOrScreenNumber does not correspond to an installed screen.');
end
if isnan(ATIRadeon7000(s))
	card=Screen(windowPtrOrScreenNumber,'VideoCard');
	ATIRadeon7000(s) = strcmp(card.cardName,'ATY,RV100ad_A') | strcmp(card.cardName,'ATY,RV100ad_B');
end
is=ATIRadeon7000(s);
