function is = IsRadiusThunder10(windowPtrOrScreenNumber)
% is = IsRadiusThunder10(windowPtrOrScreenNumber)
%
% Reads card and driver names to determine whether the card is a Radius
% graphics card with 10-bit DACs. IsRadiusThunder10 works for the Radius
% ThunderColor cards in DHB's lab. The answer is cached so subsequent 
% calls are quick.
% 
% IMPORTANT: Please try to avoid calling this routine directly. That would
% make your software platform specific, which is something we are trying
% to avoid. If you want to know your driver's DAC size (8, 9, or 10 bits)
% or how to align the bits in the gamma table then call ScreenDacBits or
% ScreenUsesHighGammaBits.

% 8/20/00  dhb  Wrote it.
% 9/9/00   dhb  Modified to use cache, check card too.
% 3/20/02  dgp	Cosmetic.
% 6/6/02   dgp	Renamed IsRadiusThunder10.
% 6/20/02  dgp	Streamlined. Only compute for screens that the user asks about.
% 6/29/02  dgp  Use new version of Screen VideoCard.

global RadiusThunder10 % Cache answers for future reference.

% Set up static information on first call.
if isempty(RadiusThunder10)
	RadiusThunder10 = NaN*Screen('Screens');
end
s=Screen(windowPtrOrScreenNumber,'WindowScreenNumber')+1;
if s<1
	error('Passed windowPtrOrScreenNumber does not correspond to an installed screen.');
end
if isnan(RadiusThunder10(s))
	card=Screen(windowPtrOrScreenNumber,'VideoCard');
	RadiusThunder10(s) = strcmp(card.driverName,'.Display_Marin') & strcmp(card.cardName,'RDUS,Marin');
end
is=RadiusThunder10(s);
