function [theSound,samplingRate] = PlayBeep(freq,durationMS,samplingRate,DONTPLAY)
% [theSound,samplingRate] = PlayBeep(freq,durationMS,[samplingRate],[DONTPLAY])
%
% OBSOLETE: please use MakeBeep instead. Note that MakeBeep specifies
% "duration" in seconds, instead of milliseconds.
%
% Play pure tone of specified freq (in Hz) and duration (in ms).  The
% sampling rate defaults to 12000 Hz, which is different from Snd's
% default.
% 
% Returns immediately, while sound is playing.
% 
% PlayBeep calls Snd.  If you wish, you can ask PlayBeep to just
% precompute the sound and later call Snd to play it.
% 
%  theSound = PlayBeep(freq,duration,samplingRate,1);
%  Snd('Open');
%  .... do some stuff ....
%  Snd('Play',theSound,samplingRate);
%
% See Snd.
%
% 6/21/95		dhb, ccc	Wrote it.
% 3/29/97		dgp 			Updated
% 4/2/97		dgp				Expanded comments above.
% 11/25/97  dhb     	Fixed comment to correctly indicate milliseconds.
% 12/10/97  dhb				Add samplingRate and DONTPLAY args, snd return.
% 										I didn't test after these changes.
% 2/9/98		dgp				Updated to use Snd instead of SndPlay.
% 2/13/98   dhb       Update (independently) for Snd.  Return sampling rate.
% 2/18/98   dgp       Obsolete.
% 4/29/98   dhb       Make call to Snd synchronous with close.

if nargin<1 | isempty(freq)
	freq = 3000;
end
if nargin<2 | isempty(durationMS)
	durationMS = 500;
end
if nargin<3 | isempty(samplingRate)
	samplingRate = 12000;
end
if nargin<4 | isempty(DONTPLAY)
	DONTPLAY = 0;
end
theSound = sin(2*pi*freq*(1:durationMS/1000*samplingRate)/samplingRate);
if ~DONTPLAY
	Snd('Play',theSound,samplingRate);
	Snd('Wait');
	Snd('Close');
end
