function err = SndPlay(sound,rate)
% err = SndPlay([sound],[rate])
% 
% SndPlay is obsolete. Please use Snd.mex instead. In order not to break old
% programs, this M file implements the old SndPlay by calling Snd. 
% However, we suggest you update your programs to take advantage of
% the superior features of Snd.
% 
% SndPlay(sound) plays a sound on a Macintosh. Unlike Matlab's SOUND
% command, SndPlay returns immediately, while the sound is still playing.
% The sound may either be a numeric array of samples, or a string giving
% the name of a Macintosh snd resource in the System file (or Matlab
% application or MEX file). Any sound currently playing is immediately 
% displaced by the new sound.
% 
% SndPlay(0) stops all sound immediately.
% 
% SndPlay with no arguments waits until all the sounds in the channel play
% through.
% 
% The "sound" data should lie between -1 and 1. If the sound array has one
% row then it's played monaurally. If it has two rows then it's played in
% stereo. 
% 
% The sample "rate" defaults to the standard Macintosh hardware sample
% rate of 22254.545454 Hz. Other values can be specified (in the range
% 1000 to 65535 Hz) but linear interpolation is used to resample the data.
% Currently the "rate" is ignored when you specify the sound by name.
% 
% SndPlay(sin(0:10000));	% play 7 kHz tone
% SndPlay([sin(1:20000) zeros(1,10000);zeros(1,10000) sin(1:20000)]); % stereo
% SndPlay('Quack');			% play named snd resource
% 
% See Snd.
% 
% Denis Pelli February 6, 1998
% 
% NOTE: SndPlay(sound) always immediately stopped whatever sound was
% playing (closing and reopening the channel) before playing the new
% sound. This was necessary to work around a bug in the pre-version-3
% Sound Manager. Based on enhancements to the underlying VideoToolbox
% routine, the new Snd(sound) leaves the existing channel open, including
% whatever sounds are in the queue, and politely adds your new sound to
% the end of the queue. This is much better: Snd returns quickly, and
% allows you to accurately play many sounds back-to-back. However, since
% the purpose of this file is compatibility, we simulate the
% sound-terminating behavior of SndPlay by calling:
% Snd('Quiet');Snd(sound);

% 6/6/96	dgp Wrote it.
% 6/1/97	dgp Polished help text.
% 12/10/97	dhb Updated help.
% 2/4/98	dgp Revised it to be based on Snd.mex.

if nargin==0
	err=Snd('Wait');
	return;
end
err=Snd('Quiet');
switch nargin
case 1;
	err=Snd('Play',sound);
	return;
case 2;
	err=Snd('Play',sound,rate);
	return;
end
