function y=fftunshift(x)
% OBSOLETE. After years of user requests, in Matlab 5.2, Mathworks finally 
% listened and added IFFTSHIFT, which is equivalent to our FFTUNSHIFT. 
% For maximum portability of your programs, you should use their routine.
%
% y=fftunshift(x); Move center of spectrum back to zeroth lag, 
%	undoing FFTSHIFT. Successively applying both 
%	fftshift and fftunshift, in either order, restores the original 
%	matrix.
%
%	D.G. Pelli & N. Majaj, 1/94, 5/96, based on FFTSHIFT.M

if sscanf(version,'%f',1)>=5.2
	error('Please use Matlab''s IFFTSHIFT instead of the Psychtoolbox fftunshift');
end
[m,n] = size(x);
m1 = 1:floor(m/2);
m2 = floor(m/2)+1:m;
n1 = 1:floor(n/2);
n2 = floor(n/2+1):n;

% Note: can remove the first two cases when null handling is fixed.
if m == 1
    y = [x(n2) x(n1)];
elseif n == 1
    y = [x(m2); x(m1)];
else
    y = [x(m2,n2) x(m2,n1); x(m1,n2) x(m1,n1)];
end

