function normalClut=ClutDefault(arg,bits)
% normalClut=ClutDefault(windowPtrOrScreenNumber,[bits])
% 
% Mac: This provides the standard CLUT for the screen's current pixelSize and 
% color-vs-grayscale setting, which you can control with Apple's Monitors control
% panel or Screen 'PixelSize'. This default clut array is useful as a fallback if
% you can't or don't want to call GetClut, either because GetClut isn't available,
% or because the CLUT might already have been messed with.
% 
% "bits" defaults to 8. If bits>8 then the standard 8-bit table is scaled to the 
% specified resolution.
% 
% normalClut=ClutDefault(res)
%
% This provides the standard CLUT for the specified res.pixelSize and res.bits.

% 7/12/98  dgp  Wrote it.
% 7/14/98 dgp At dhb's suggestion, merged with his DefaultClut 8-bit code.
%				We still need to add the default cluts for pixelSizes 2 and 4,
%				which is just a matter of calling GetClut and printing the clut.
% 7/15/98 dgp Added pixelSize 2 and 4, and color vs grayscale.
% 11/1/99 dgp Cosmetic.
% 4/17/02 dgp Accept res struct.
% 6/23/02 dgp Accept "bits".
% 6/24/02 dgp Corrected the 16-bit clut to match Mac OS.

if nargin<2
	bits=8;
end
if nargin<1
	error('Usage:  normalClut=ClutDefault(windowPtrOrScreenNumber) or normalClut=ClutDefault(res)');
end
if isstruct(arg)
	if ~isfield(arg,'pixelSize')
		error('"res" argument must have a pixelSize field');
	end
	pixelSize=arg.pixelSize;
	if isfield(arg,'bits')
		bits=arg.bits;
	end
	isColor=1; % a guess
else
	[pixelSize,isColor]=Screen(arg,'PixelSize');
end
switch pixelSize
	case 32, normalClut=[0:255;0:255;0:255]';
case 16, normalClut=[
	     0     0     0
	     8     8     8
	    16    16    16
	    24    24    24
	    33    33    33
	    41    41    41
	    49    49    49
	    57    57    57
	    66    66    66
	    74    74    74
	    82    82    82
	    90    90    90
	    99    99    99
	   107   107   107
	   115   115   115
	   123   123   123
	   132   132   132
	   140   140   140
	   148   148   148
	   156   156   156
	   165   165   165
	   173   173   173
	   181   181   181
	   189   189   189
	   198   198   198
	   206   206   206
	   214   214   214
	   222   222   222
	   231   231   231
	   239   239   239
	   247   247   247
	   255   255   255
	];	
	case 8,
	normalClut = [
	   255   255   255
	   255   255   204
	   255   255   153
	   255   255   102
	   255   255    51
	   255   255     0
	   255   204   255
	   255   204   204
	   255   204   153
	   255   204   102
	   255   204    51
	   255   204     0
	   255   153   255
	   255   153   204
	   255   153   153
	   255   153   102
	   255   153    51
	   255   153     0
	   255   102   255
	   255   102   204
	   255   102   153
	   255   102   102
	   255   102    51
	   255   102     0
	   255    51   255
	   255    51   204
	   255    51   153
	   255    51   102
	   255    51    51
	   255    51     0
	   255     0   255
	   255     0   204
	   255     0   153
	   255     0   102
	   255     0    51
	   255     0     0
	   204   255   255
	   204   255   204
	   204   255   153
	   204   255   102
	   204   255    51
	   204   255     0
	   204   204   255
	   204   204   204
	   204   204   153
	   204   204   102
	   204   204    51
	   204   204     0
	   204   153   255
	   204   153   204
	   204   153   153
	   204   153   102
	   204   153    51
	   204   153     0
	   204   102   255
	   204   102   204
	   204   102   153
	   204   102   102
	   204   102    51
	   204   102     0
	   204    51   255
	   204    51   204
	   204    51   153
	   204    51   102
	   204    51    51
	   204    51     0
	   204     0   255
	   204     0   204
	   204     0   153
	   204     0   102
	   204     0    51
	   204     0     0
	   153   255   255
	   153   255   204
	   153   255   153
	   153   255   102
	   153   255    51
	   153   255     0
	   153   204   255
	   153   204   204
	   153   204   153
	   153   204   102
	   153   204    51
	   153   204     0
	   153   153   255
	   153   153   204
	   153   153   153
	   153   153   102
	   153   153    51
	   153   153     0
	   153   102   255
	   153   102   204
	   153   102   153
	   153   102   102
	   153   102    51
	   153   102     0
	   153    51   255
	   153    51   204
	   153    51   153
	   153    51   102
	   153    51    51
	   153    51     0
	   153     0   255
	   153     0   204
	   153     0   153
	   153     0   102
	   153     0    51
	   153     0     0
	   102   255   255
	   102   255   204
	   102   255   153
	   102   255   102
	   102   255    51
	   102   255     0
	   102   204   255
	   102   204   204
	   102   204   153
	   102   204   102
	   102   204    51
	   102   204     0
	   102   153   255
	   102   153   204
	   102   153   153
	   102   153   102
	   102   153    51
	   102   153     0
	   102   102   255
	   102   102   204
	   102   102   153
	   102   102   102
	   102   102    51
	   102   102     0
	   102    51   255
	   102    51   204
	   102    51   153
	   102    51   102
	   102    51    51
	   102    51     0
	   102     0   255
	   102     0   204
	   102     0   153
	   102     0   102
	   102     0    51
	   102     0     0
	    51   255   255
	    51   255   204
	    51   255   153
	    51   255   102
	    51   255    51
	    51   255     0
	    51   204   255
	    51   204   204
	    51   204   153
	    51   204   102
	    51   204    51
	    51   204     0
	    51   153   255
	    51   153   204
	    51   153   153
	    51   153   102
	    51   153    51
	    51   153     0
	    51   102   255
	    51   102   204
	    51   102   153
	    51   102   102
	    51   102    51
	    51   102     0
	    51    51   255
	    51    51   204
	    51    51   153
	    51    51   102
	    51    51    51
	    51    51     0
	    51     0   255
	    51     0   204
	    51     0   153
	    51     0   102
	    51     0    51
	    51     0     0
	     0   255   255
	     0   255   204
	     0   255   153
	     0   255   102
	     0   255    51
	     0   255     0
	     0   204   255
	     0   204   204
	     0   204   153
	     0   204   102
	     0   204    51
	     0   204     0
	     0   153   255
	     0   153   204
	     0   153   153
	     0   153   102
	     0   153    51
	     0   153     0
	     0   102   255
	     0   102   204
	     0   102   153
	     0   102   102
	     0   102    51
	     0   102     0
	     0    51   255
	     0    51   204
	     0    51   153
	     0    51   102
	     0    51    51
	     0    51     0
	     0     0   255
	     0     0   204
	     0     0   153
	     0     0   102
	     0     0    51
	   238     0     0
	   221     0     0
	   187     0     0
	   170     0     0
	   136     0     0
	   119     0     0
	    85     0     0
	    68     0     0
	    34     0     0
	    17     0     0
	     0   238     0
	     0   221     0
	     0   187     0
	     0   170     0
	     0   136     0
	     0   119     0
	     0    85     0
	     0    68     0
	     0    34     0
	     0    17     0
	     0     0   238
	     0     0   221
	     0     0   187
	     0     0   170
	     0     0   136
	     0     0   119
	     0     0    85
	     0     0    68
	     0     0    34
	     0     0    17
	   238   238   238
	   221   221   221
	   187   187   187
	   170   170   170
	   136   136   136
	   119   119   119
	    85    85    85
	    68    68    68
	    34    34    34
	    17    17    17
		0     0     0
	];
	case 4, normalClut=[
	   255   255   255
	   252   243     5
	   255   100     2
	   221     8     6
	   242     8   132
	    70     0   165
	     0     0   212
	     2   171   234
	    31   183    20
	     0   100    17
	    86    44     5
	   144   113    58
	   192   192   192
	   128   128   128
	    64    64    64
	     0     0     0
	];
	case 2, normalClut=[
	   255   255   255
	   172   172   172
	    85    85    85
	     0     0     0
	];
	case 1, normalClut=[255 255 255;0 0 0];
end
if ~isColor
	switch pixelSize
		case 8, normalClut=[255:-1:0;255:-1:0;255:-1:0]';
		case 4, normalClut=[255:-17:0;255:-17:0;255:-17:0]';
		case 2, normalClut=[255:-85:0;255:-85:0;255:-85:0]';
	end
end		
normalClut=bitshift(normalClut*257,bits-16); % extend from 8 to "bits" bits.
