function DescribeScreen(screenNumber)
% DescribeScreen(screenNumber) prints out several lines describing the
% video driver for the specified screen. If the screenNumber is omitted it
% defaults to all screens. If the screenNumber is negative we just print a
% line marking the end of the table. This was originally written for use
% by ScreenTest.m, but is now used by most of the screen-oriented programs
% in PsychTest. Here's how it's typically used:
% 
% 	for screenNumber=Screen('Screens')
% 		DescribeScreen(screenNumber);
% 		DescribeScreenPrefs(screenNumber); % more info
% 		DescribeScreen(-2); % print a light line
% 		% Do your work here, testing screen "screenNumber".
% 	end
% 	DescribeScreen(-1); % print a heavy line
% 
% Try ScreenTest. Also see DescribeScreenPrefs, DescribeComputer.
% 
% Douglas Taylor <dtaylor@ski.org> says, "We don't have any GeForce4Ti's as yet. 
% But they are now available from the Apple store for $399.00."
% http://store.apple.com/1-800-MY-APPLE/WebObjects/AppleStore.woa/42/wo/whZV00bqpYG6JvekmS/1.3.0.3.30.8.3.8.13.0

% 7/12/98 dgp wrote it
% 4/12/99 dgp reduced line length so the output can be emailed without linewrapping
% 1/24/00 dgp use new 'Resolutions' to add list of available frame rates.
% 1/26/00 dgp Fix bug detected by David when 'Resolutions' returns no valid value.
% 2/10/00 dgp Round hz before calling UNIQUE.
% 8/10/00 dgp Report support for new driver calls.
% 4/29/02 awi Added Windows section. 
% 4/30/02 dgp Win: print resolution. 
% 5/5/02  dgp More help text.
% 6/1/02  dgp Moved the driver options, e.g. AskSetClutDriverToWaitForBlanking, to SetClutWaitTest.m.
% 6/6/02  dgp Use new routine ScreenDacBits, which gives more reliable answer.
% 6/18/02 dgp Preferences.
% 6/29/02 dgp Identify card by name, if we recognize it.
% 7/1/02  dgp Added ten card names, supplied by Douglas Taylor <dtaylor@ski.org>.
% 7/28/02 dgp Use cardName instead of cardNameLong.
% 12/17/02 dgp Added Radeon 9000.

if nargin==0
	for screenNumber=Screen('Screens')
		DescribeScreen(screenNumber);
	end
	DescribeScreen(-1);
	return
end
if screenNumber<0
	switch(screenNumber)
	case -1,
		fprintf('**************************************************************************\n')
	case -2,
		fprintf(' -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -\n')
	case -3,
		fprintf(' .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .\n')
	end
	return
end

fprintf('*** Screen %d *************************************************************\n',screenNumber);
if strcmp('PCWIN', computer)
    fprintf('Windows DirectX display. '); 
	r=Screen(screenNumber,'Rect');
	fprintf('%dx%d ',RectWidth(r),RectHeight(r));
	hz=FrameRate(screenNumber);
	fprintf('%.0f Hz.\n',hz);
elseif strcmp('MAC2',computer)
	% Identify cardName. Please also update similar table in PrepareScreen.
	card=Screen(screenNumber,'VideoCard');
	switch card.cardName
	case 'ATY,264LTProA',     fprintf('ATI mach64, port A\n'); % David Brainard G3 PowerBook.
	case 'ATY,264LTProB',     fprintf('ATI mach64, port B\n'); % " "
	case 'ATY,BlueStone_A',   fprintf('ATI Radeon 7500, port A\n');
	case 'ATY,BlueStone_B',   fprintf('ATI Radeon 7500, port B\n');
	case 'ATY,Crown_A',       fprintf('ATI Mobility Radeon 7500 (AGP 4x), port A\n'); % Chris Chase G4 PowerBook.
	case 'ATY,Crown_B',       fprintf('ATI Mobility Radeon 7500 (AGP 4x), port B\n'); % " "
	case 'ATY,mach64_3DUPro', fprintf('ATI ATI Rage Pro\n'); % Denis Pelli G3 PowerMac.
	case 'ATY,Pheonix_A',     fprintf('ATI Radeon 9000, port A\n'); % David Heeger's G4/867 PowerMac in fMRI room
	case 'ATY,Pheonix_B',     fprintf('ATI Radeon 9000, port B\n');
	case 'ATY,R200i_A',       fprintf('ATI Radeon 8500, port A\n');
	case 'ATY,R200i_B',       fprintf('ATI Radeon 8500, port B\n');
	case 'ATY,RADEONp',       fprintf('ATI Radeon 7200, retail, PCI, aka "Radeon Mac Ed. (PCI)"\n'); % Tony Jack, Doug Taylor, David Jones.
	case 'ATY,RADEONr',       fprintf('ATI Radeon 7200, retail, AGP\n');
	case 'ATY,Rage128k',      fprintf('ATI Rage128\n');
	case 'ATY,Rage128Pd',     fprintf('ATI Rage128Pro, AGP\n'); % Tony Jack <ajack@npg.wustl.edu>
	case 'ATY,Rage128Ps',     fprintf('ATI Rage128Pro, AGP\n'); % David Jones <djones@ece.mcmaster.ca> G4 PowerMac
	case 'ATY,Rage128y',      fprintf('ATI Rage128\n');
	case 'ATY,Rage6ag',       fprintf('ATI Radeon, oem, AGP\n');
	case 'ATY,Rage6p',        fprintf('ATI Radeon, oem, PCI\n');
	case 'ATY,RageM3p12A',    fprintf('ATI Rage Mobility 128, port A\n'); % Denis Pelli G4 PowerBook.
	case 'ATY,RageM3p12B',    fprintf('ATI Rage Mobility 128, port B\n'); % " "
	case 'ATY,RageM3p29s',    fprintf('ATI Rage Mobility 128 (AGP 2x)\n'); % David Jones G3 iBook/600.
	case 'ATY,RV100ad_A',     fprintf('ATI Radeon 7000, port A\n'); % Denis Pelli, bought card from ATI. David Brainard.
	case 'ATY,RV100ad_B',     fprintf('ATI Radeon 7000, port B\n'); % " "
	case 'ATY,Stone_A',       fprintf('ATI Mobility Radeon, port A\n');
	case 'ATY,Stone_B',       fprintf('ATI Mobility Radeon, port B\n');
	case 'control',           fprintf('PowerMac 75/76/85/8600 Built-in Apple Video\n');
	case 'MaPi_850_750',      fprintf('VillageTronic MacPicasso 850 (Banshee chip)\n');
	case 'MaPi_Voodoo3',      fprintf('VillageTronic MacPicasso 760 (Voodoo3 chip)\n');
	case 'NVDA,Display-A',    fprintf('NVIDIA GeForce4MX, port A\n');
	case 'NVDA,Display-B',    fprintf('NVIDIA GeForce4MX, port B\n');
	case 'NVDA,NVMac',        fprintf('NVIDIA GeForce2\n');
	case 'RDUS,Marin',        fprintf('Radius ThunderPower\n');
end
fprintf('"%s" (%s version %s)',card.cardName,card.driverName,card.driverVersion);
if length(card.slotName)>0
	fprintf(' in slot %s',card.slotName);
end
fprintf('\n');

% Report dacBits, screen size, FrameRate, and available frame rates.
dacBits=ScreenDacBits(screenNumber);
fprintf('%d bit dacs. ',dacBits);
r=Screen(screenNumber,'Rect');
fprintf('%dx%d ',RectWidth(r),RectHeight(r));
hz=FrameRate(screenNumber);
fprintf('%.0f Hz.',hz);
res=Screen(screenNumber,'Resolutions');
hz=unique(round([res(:).hz]));	% discard duplicates
hz=hz(isfinite(hz));	% discard NaNs
if length(hz)>0
	fprintf(' (');
	for i=1:length(hz)
		fprintf('%.0f',hz(i));
		if i<length(hz)
			fprintf(',');
		end
	end
	fprintf(' Hz avail)');
end
fprintf('\n');
else
    ss=sprintf('%s Unknown platform %s.',computer);
end
