function DescribeScreenPrefs(screenNumber)
% DescribeScreenPrefs(screenNumber) prints out several lines describing
% the graphics driver for the specified screen. If the screenNumber is
% omitted it defaults to all screens. In order to be succinct, it only
% prints out facts that differ from what one would typically assume to be
% true. This was written for use by ScreenTest.m and other
% screen-oriented programs in PsychTest. Here's how it's typically used:
% 
% 	DescribeComputer;
% 	for screenNumber=Screen('Screens')
% 		DescribeScreen(screenNumber);
% 		DescribeScreenPrefs(screenNumber);
% 		DescribeScreen(-2); % print light line
% 		% Do your work here, testing screen "screenNumber".
% 	end
% 	DescribeScreen(-1); % print heavy line
% 
% Try ScreenTest. Also see DescribeScreen, DescribeComputer.

% 6/19/02 dgp Wrote it.
% 6/25/02 dgp Add screenGlobal(s).fixATIRadeon7000.
% 6/30/02 dgp Merged "Supports:" into "Prefs:". Call WrapString at end.

if nargin==0
	for screenNumber=Screen('Screens');
		DescribeScreen(screenNumber);
		DescribeScreenPrefs(screenNumber);
	end
	DescribeScreen(-1);
	return
end

global screenGlobal

% Report non-standard Preference settings
ss=sprintf('Prefs:');
csc=Screen(screenNumber,'Preference','DriverFlags');
if csc.cscGetClutBehavior
	ss=sprintf('%s cscGetClutBehavior,',ss);
end
if csc.cscGetNextResolution
	ss=sprintf('%s cscGetNextResolution,',ss);
end
if csc.cscGetTimingRanges
% 	ss=sprintf('%s cscGetTimingRanges,',ss);
end
if csc.cscGetDetailedTiming
% 	ss=sprintf('%s cscGetDetailedTiming,',ss);
end
if Screen(screenNumber,'Preference','DacBits')~=8
% 	ss=sprintf('%s DacBits %d,',ss,Screen(screenNumber,'Preference','DacBits'));
end
if Screen(screenNumber,'Preference','UseHighGammaBits')
	ss=sprintf('%s UseHighGammaBits,',ss);
end
if Screen(screenNumber,'Preference','SetClutDuplicates8Bits')
	ss=sprintf('%s SetClutDuplicates8Bits,',ss);
end
if isfield(screenGlobal,'fixATIRadeon7000') & screenGlobal(screenNumber+1).fixATIRadeon7000
	ss=sprintf('%s fixATIRadeon7000,',ss);
end
if Screen(screenNumber,'Preference','DipPriorityAfterSetClut')
	ss=sprintf('%s DipPriorityAfterSetClut,',ss);
end
if Screen(screenNumber,'Preference','MinimumSetClutPriority')
	ss=sprintf('%s MinimumSetClutPriority %d,',ss,Screen(screenNumber,'Preference','MinimumSetClutPriority'));
end
if Screen(screenNumber,'Preference','MaximumSetClutPriority')~=7
	ss=sprintf('%s MaximumSetClutPriority %d,',ss,Screen(screenNumber,'Preference','MaximumSetClutPriority'));
end
if Screen(screenNumber,'Preference','MinimumEntriesForSetClutToWaitForBlanking')>1
	ss=sprintf('%s MinimumEntriesForSetClutToWaitForBlanking %d,',ss,Screen(screenNumber,'Preference','MinimumEntriesForSetClutToWaitForBlanking'));
end
if Screen(screenNumber,'Preference','BlankingDuration')~=0.0003
	ss=sprintf('%s BlankingDuration %0.4f s,',ss,Screen(screenNumber,'Preference','BlankingDuration'));
end
if ~Screen(screenNumber,'Preference','SetClutDriverWaitsForBlanking')
	ss=sprintf('%s SetClutDriverWaitsForBlanking 0,',ss);
end
if ~strcmp(ss(end),':')
	ss(end)='.';
	fprintf('%s\n',WrapString(ss));
end
