function gamma=GammaDefault(windowPtrOrScreenNumber)
% gamma=GammaDefault(windowPtrOrScreenNumber)
% 
% Mac: This provides a standard identity gamma table for the screen, 
% using the same precision as its current gamma table. 
% This default gamma table is used to restore the screen
% to a useful state when you're done.

% 6/16/02 dgp Wrote it, based on DefaultClut.

if nargin<1
	error('Usage:  gamma=GammaDefault(windowPtrOrScreenNumber)');
end
[oldGamma,oldBits,gammaError]=Screen(windowPtrOrScreenNumber,'Gamma');
gamma=bitshift(257*[0:255]',16-oldBits);
