function bool=IsInOrder(string1,string2)
% bool=IsInOrder(string1,string2)

% 9/29/02 dgp Added error for old MATLAB. I know it fails on 5.0 and works on 5.2.1. I don't know about 5.1 and 5.2.
% 				I'm sure one could easily modify this to work on 5.0, but we no longer have 5.0 on any of our machines,
%				so we have no way of testing it, and it seems better to encourage users to upgrade (and benefit from the
%				important bug fixes in MATLAB 5.2.1, than to spend our limited development time dealing with an obsolete
%				version.

if nargin~=2
	error('Usage: bool=IsInOrder(string1,string2)');
end
if sscanf(version,'%f',1)<5.1
	error('Sorry, your MATLAB version is too old. Please upgrade to 5.2.1 (for Mac OS), or better on other platforms.');
end
[s,i]=sort({string1 string2});
bool = i(1)==1;
