function bool = IsPopCharProInstalled
% IsPopCharProInstalled returns a quick answer to the yes/no question of
% whether PopChar Pro is installed. PopChar Pro 1.3.3 is not compatible
% with Matlab. See PopCharTest.
% 
% We only look for "PopChar Pro", which is the currently available
% commercial version. We don't look for the older "PopChar", which was
% free, but no longer seems to be available. We haven't tested PopChar; it
% may be ok. 
% web http://www.unisoft.co.at/products/popchar.html
% 
% We use this test to warn the user about PopChar Pro,
% and, if we detect it, suggest that it be removed. See ScreenTest.

% 2/24/02 dgp Wrote it.
% 3/5/02  dgp Use Gestalt record instead of searching for Control Panel. 
% 6/27/02 dgp In response to bug report from David Jones <djones@ece.mcmaster.ca>
%             check for version 5.2.1 before assuming that a usable version of
% 			  gestalt is available. (gestalt error is always fatal in earlier versions.)

if strmatch('5.2.1',version) % need MATLAB 5.2.1 for a usable GESTALT
	% Detect Popchar Pro by its Gestalt record.
	g=gestalt('Pop');
	bool=length(g)>1;
else
	% Look for Popchar Pro control panel, by name.
	mroot=matlabroot;
	i=find(mroot==filesep);
	root=mroot(1:i(1));
	p=fullfile(root,'System Folder','Control Panels','PopChar Pro');
	s=dir(p);
	bool=~isempty(s);
end
