function px_p = CoinFlipPDF(x,p)
% px_p = CoinFlipPDF(x,p)
%
% Return the probability that a random variable x
% was generated by a CoinFlip with probability of
% heads given by p.  If x is a vector, then p is
% a vector containing the probability for each x.
%
% xx/xx/xx  dhb  Wrote it.

% Generate an array of zeros
[m,n] = size(x);
px_p = zeros(m,n);

% Put p at every entry where x contains 1
index = find( x == 1 );
[m,n] = size(index);
px_p(index) = p*ones(m,n);

% Put 1-p at every entry where x contains 0
index = find( x == 0 );
[m,n] = size(index);
px_p(index) = (1-p)*ones(m,n);
  
