function p=QuestPdf(q,t)
% p=QuestPdf(q,t)
% The (unnormalized) probability density of candidate threshold "t".
% See QuestCreate, QuestUpdate, QuestQuantile, QuestMean, QuestMode,
% QuestSd, and QuestSimulate.
%
% Denis Pelli

% 5/6/99 dgp wrote it
% Copyright (c) 1996-1999 Denis Pelli

if nargin~=2
	error('Usage: p=QuestPdf(q,t)')
end
if size(q)~=size(t)
	error('the arguments must have same dimensions')
end
if length(q)>1
	p=zeros(size(q));
	for i=1:length(q(:))
		p(i)=QuestPdf(q(i),t(i));
	end
	return
end
i=round((t-q.tGuess)/q.grain)+1+q.dim/2;
i=min(length(q.pdf),max(1,i));
p=q.pdf(i);
