function trial=QuestTrials(q)
% trial=QuestTrials(q)
% Return sorted list of intensities and response frequencies.
% See QuestDemo, QuestCreate, QuestUpdate, QuestQuantile, QuestMean, QuestMode,
% QuestSd, and QuestSimulate.
%
% Denis Pelli

% 5/4/99 dgp wrote it
%
% Copyright (c) 1996-1999 Denis Pelli

if nargin~=1
	error('Usage: trial=QuestTrials(q)')
end
if length(q)>1
	for i=1:length(q(:))
		trial(i)=QuestTrials(q(i));
	end
	return
end
% sort
[intensity,i]=sort(q.intensity);
response(1:length(i))=q.response(i);
% compact
j=1;
trial.intensity(j)=intensity(1);
trial.responses(j,1:2)=[0 0];
for i=1:length(intensity)
	if intensity(i)~=trial.intensity(j)
		j=j+1;
		trial.intensity(j)=intensity(i);
		trial.responses(j,1:2)=[0 0];
	end
	trial.responses(j,response(i)+1)=trial.responses(j,response(i)+1)+1;
end
