function BackgroundingTest
% BackgroundingTest
% Confirm that enhanced Backgrounding code works. Our MEX files now use
% the new Matlab 5.2.1 new system_dependent('backgrounding') function
% to determine whether Backgrounding is enabled, instead of the old
% method of checking the Matlab prefs file. When the new function isn't
% available we fall back on the old method.

% 3/15/99 dgp Wrote it.
% 3/17/99 dgp Enhanced to work on earlier versions of Matlab.
% 3/28/99 dgp Test setting of Backgrounding.
% 4/24/02 awi Exit on PC with message.

if strcmp('PCWIN',computer)
    error('Win: BackgroundingTest not yet supported.');
end

v=eval('sscanf(version,''%f'',2)''*[1; 0.1]','sscanf(version,''%f'',1)');
if v>5.2
	ok=1;
	for i=1:2
		% explicitly undocumented new Matlab function
		system_dependent('backgrounding','on');
		s=system_dependent('backgrounding');
		boolean=Screen('Preference','Backgrounding');
		fprintf('Backgrounding? %3s %d\n',s,boolean);
		ok=ok & ((boolean & strcmp(s,'on')) | (~boolean & strcmp(s,'off')));
		system_dependent('backgrounding','off');
		s=system_dependent('backgrounding');
		boolean=Screen('Preference','Backgrounding');
		fprintf('Backgrounding? %3s %d\n',s,boolean);
	end
	newBoolean=~boolean;
	for i=1:2
		% test our function that uses it
		oldBoolean=Screen('Preference','Backgrounding',newBoolean);
		ok=ok & (boolean == oldBoolean);
		boolean=newBoolean;
		newBoolean=~newBoolean;
	end
	if ok
		fprintf('Success! Backgrounding control works.\n');
	else
		fprintf('Error! Backgrounding control/reporting isn''t working correctly.\n');
	end
else
	boolean=Screen('Preference','Backgrounding');
	fprintf('Backgrounding? %d\n',boolean);
	fprintf('If you upgrade your Matlab from version %s to 5.2.1\n',version);
	fprintf('then you''ll be able to turn Backgrounding on and off dynamically.\n');
	fprintf('The upgrade is free. <http://www.mathworks.com/>\n');
end
