% BytesTest.m
%
% Demonstrate the Bytes mex file. 
%
% 1/20/96  dgp Wrote it
% 3/16/97  dgp Updated
% 10/16/02 awi Exit on Win only with message that Bytes is not yet supported. 
% 10/18/02 awi Cosmetic.  
%              Added Windows section.  Added tests for detectiong foreign OS
%              arguments. Left mac section alone.  

winArgs = {'SystemRAMLoad','SystemRAM','SystemRAMFree','SystemPage','SystemPageFree','SystemTotal','SystemTotalFree'};
macArgs = {'Free', 'TempFree', 'MaxBlock','StackSpace','MaxMem','TempMaxMem'};

if strcmp(computer,'MAC2')


    %try the Mac functions in MacOS
    fprintf('\n\n');
    fprintf('BytesTest will now test bytes commands for Mac on Mac...\n')

    free=system_dependent(1003)			% undocumented built-in Matlab function
	free=Bytes							% Apple's FreeMem(). Innocuous.
	free=Bytes('Free')					% "          "          "
	tempFree=Bytes('TempFree')			% Apple's TempFreeMem(). Innocuous.
	maxBlock=Bytes('MaxBlock')			% Apple's MaxBlock(). Innocuous.
	stackSpace=Bytes('StackSpace')		% Apple's StackSpace(). Innocuous.
	
	disp('NOTE: The following two calls may take a while; they move memory.')
	maxMem=Bytes('MaxMem')				% Apple's MaxMem(). CAUTION: moves memory!
	tempMaxMem=Bytes('TempMaxMem')		% Apple's TempMaxMem(). CAUTION: moves memory!
    
    %try the Win functions in MacOS
    fprintf('\n\n');
    fprintf('BytesTest will now test bytes commands for Win on Mac...\n')
    for i = 1:length(winArgs)
        lasterr('')
        if eval('bytes(winArgs{i})','-1')==-1
            if isempty(findstr('is specific to the Win version',lasterr))
                fprintf(['Bytes detected that "' winArgs{i} '" was an invalid command on Mac but did not recognize it as a Winodows command.\n']);
            else 
                fprintf(['Bytes detected that "' winArgs{i} '" was a Win command invalid on Mac.\n']);
            end
        else
            fprintf(['Bytes detected that the Win command"' winArgs{i} '" was also a valid command on Mac.\n']);
        end
    end
    
            

elseif strcmp(computer,'PCWIN')
    
    %evaluate Windows arguments.  These should work.  
    fprintf('\n');
    fprintf('BytesTest will now test bytes commands for Win on Win...\n\n')
    for i = 1:length(winArgs)
        fprintf('%-20s%d\n' ,winArgs{i},bytes(winArgs{i}));
    end
    
    %evaluate Mac arguments.  These should fail.
    fprintf('\n\n');
    fprintf('BytesTest will now test bytes commands for Mac on Win...\n\n')
    for i = 1:length(macArgs)
        lasterr('')
        if eval('bytes(macArgs{i})','-1')==-1
            if isempty(findstr('is specific to the Mac version',lasterr))
                fprintf(['Bytes detected that "' macArgs{i} '" was an invalid command on Win but did not recognize it as a Mac command.\n']);
            else 
                fprintf(['Bytes detected that "' macArgs{i} '" was a Mac command invalid on Win.\n']);
            end
        else
            fprintf(['Bytes detected that the Mac command"' macArgs{i} '" was also a valid command on Win.\n']);
        end
    end
        
end
