function ColorTest
% ColorTest exercises all the Screen functions that accept a "color"
% argument, showing that they work consistently at all pixelSizes. 
% Note that specification of "color" as an [r g b] triplet is only 
% allowed when pixelSize is 16 or 32.

% 4/1/98 dgp    Wrote it.
% 4/6/98 dgp    Wait 2 s instead of waiting for click.
% 4/1/02 dgp    Test all screens.
% 2/19/04 awi   Excluded 16-bit screen depth from Windows version.

help ColorTest
for whichScreen=Screen('Screens');
    pixelSizes=Screen(whichScreen,'PixelSizes');
    if(strcmp(computer,'PCWIN'))
        pixelSizes=setdiff(pixelSizes,16);
    end
	for pixelSize=pixelSizes;
		w=screen(whichScreen,'OpenWindow',[],[],pixelSize);
		white=WhiteIndex(w);
		black=BlackIndex(w);
		gray=round(GrayIndex(w,0.5));
		if gray==white
			gray=black;
		end
		r=Screen(w,'Rect');
		Screen(w,'DrawLine',GrayIndex(w,0.3),0,r(RectBottom)/2,r(RectRight),r(RectBottom)/2,10,10);
		Screen(w,'FrameArc',GrayIndex(w,0.8),[],0,90,10,10);
		Screen(w,'FrameOval',GrayIndex(w,0.1),[],10,10);
		Screen(w,'FrameRect',GrayIndex(w,0.7),[],10,10);
	 	Screen(w,'FillPoly',white,[200 400;400 200;1000 400;400 600;200 400]);
		if psychtoolboxversion>2.44
		  	Screen(w,'FillArc',GrayIndex(w,0.8),[],0,90);
		end
		Screen(w,'FillOval',gray,[600 200 1000 600]);
		Screen(w,'FillRect',black,[200 200 600 600]);
		Screen(w,'TextSize',30);
		string=sprintf('pixelSize %d',pixelSize);
		if pixelSize>8
			color=[white,black,black];	% red
			string=[string ', RGB color'];
		else
			color=gray;
			string=[string ', grayscale'];
		end
		Screen(w,'DrawText',string,250,412,color);
		ramp=0:max(white,black);
		Screen(w,'PutImage',ramp,[0 0 length(ramp) length(ramp)]);
		WaitSecs(4);
		screen(w,'Close');
	end
end
