% Psychtoolbox:PsychTests.
% 
% help Psychtoolbox % For an overview, triple-click me & hit enter.
% 
% Please try ScreenTest.
% 
% These programs exercise various aspects of the Psychophysics Toolbox, the
% Matlab environment, and your computer to document how well they work.
% The results give insight into several performance issues, but may be too
% cryptic for beginners.  The programs in PsychDemos are intended to be
% more tutorial in nature.
% 
% The starred (*) tests are more ambitious, and systematically 
% characterize your computing environment, including the video cards,
% computer, Psychtoolbox, Matlab, and OS. These analyses may help you
% understand how to fully exploit your set up. The rest of the tests are
% less interesting, simply exercising the function to show that it runs to
% completion. Some of these are derived from the minimal programs users
% submitted as part of a bug report, to document the fix.
% 
% help psychdemos % For demos, triple-click me and hit enter.
% 
% TIP: If you're going to run many of these tests, you may find it
% convenient to copy the list into a new window. Double-click to select a
% test; hit enter to run it.
% 
% The "Use" column stars (*) particularly informative tests, and indicates
% which platforms (Mac and Win) are supported.
%
%   Test                  Use    Description
%  
%   ArcTest                 M W  Compare boundaries of Screen 'FrameArc' and 'FillArc'.
%   BackgroundingTest       M    Test enhanced Backgrounding code in Screen.mex.
%   BytesTest               M W  Test Bytes.mex.
%   ClipTest                M    Test copy and paste of matrices.
%   ClutRoundingTest        M    Determine what to put in lower 8 bits of each clut entry supplied to SetClut.
%   ClutTest              * M    Assess loading of the CLUT in graphics cards with 8-or-more-bit DACs. 
%   ClutTimeTest            M    TIme iteration rate of WaitBlanking, SetClut, and LoadClut.
%   ColorTest               M W  Test Screen functions that accept a "color" argument
%   CursorTest              M    Test hiding and showing of the cursor.
%   DrawTest                M    Test if Screen drawing pokes the right color
%   ExitTest                M W  Test automatic clean up on error.
%   FitCumNormYNTest        M    Fit a cumulative normal to yes-no data.
%   FitWeibullTAFCTest      M W  Fit a Weibull to 2AFC data.
%   FitWeibullYNTest        M    Fit a Weibull to yes-no data.
%   FlickerTest           * M    Display a counterphase-flickered grating at maximum speed.
%   GetCharTest             M    Evaluate timing info returned by GetChar.
%   GetClicksTest           M    Test GetClicks/GetMouse event handling.
%   GetImageTest            M    Test Screen 'GetImage'.  This is also done in ScreenDemo.
%   GetSecsTest             M    Adjust rate of GetSecs to match Mac OS Time Manager.
%   HelpTest                M W  Prints help text of every file in a directory.
%   HideCursorTest          M    Make sure cursor stays hidden while we wait for user input.
%   LabLuvTest              M W  Test routines that convert to CIELAB and CIELUV.
%   LeakTest                M    Test for memory leaks.
%   LoadClutTest            M    Test LoadClut, which supports graphics cards with 8-or-more-bit DACs. 
%   LogTrapsTest            M    Log system traps. WARNING: Requires MacsBug.
%   LoopTest                M W  Measure variance of loop timing in Matlab.
%   MenuBarTest             M    Checks for problems hiding the menu bar.
%   MexTest                 M    Check Psychtoolbox MEX files. Explain Matlab Debugger.
%   ModeTest                M W  Test Screen 'PutImage' modes.
%   OpenDLGCloseTest        M    Test Screen enhancement to work around Matlab DLG bug.
%   OSAUCSTest              M    Test OSA UCS <-> XYZ conversion routines.
%   PasteImageTest          M    Test PasteImage and CopyImage.
%   PeekBlankingTest        M    Measure and graph how well WaitBlanking synchs to your display.
%   PeekBlankingSimpleTest  M    More simple minded approach to testing PeekBlanking.
%   PixelSizeTest           M W  Does this crash your computer? Please tell us.
%   PixTest                 M    Make sure Screen 'Close' copes with unexpected pixelSize change.
%   PopCharTest             M W  Demonstrates an init conflict caused by PopChar Pro 1.3.3
%   PsychSerialTest         M    Exercise PsychSerial.mex.
%   PupilDiameterTest       M W  Test functions that compute pupil diameter from luminance.
%   PutImageTest            M    Test Screen 'PutImage' and 'GetImage'.
%   QuestTest               M W  Some Quest simulations, more elaborate than QuestDemo.
%   ResolutionTest        * M    Use Screen Resolutions to print table of display resolutions.
%   ResolutionQuicklyTest   M    Exercise Screen ResolutionQuickly.
%   RushTest              * M    Test Rush's reduction of interruptions (variance).
%   SaveAsEpsTest           M    Checks out Screen SaveAsEps, which saves an image to disk.
%   ScreenLeakTest          M    Measures memory leakage associated with opening and closing windows.
%   ScreenSaverTest         M    Test effect of ScreenSaver.mex and Screen 'OpenWindow' on screen saver.
%   ScreenTest            * M W  Thorough assessment of all your screens. Highly recommended.
%   SetClutTest             M    Times Screen 'SetClut' at all pixelSizes and priorities.
%   ShowtimeLeakTest        M    Assesses memory leakage in Showtime.mex.
%   ShowtimePhotoTest       M    Tests Showtime.mex with a photo.
%   ShowtimeTest            M    Tests Showtime.mex by making and showing a QuickTime movie.
%   SndTest                 M W  Compare quality of 8 and 16 bit sound.
%   SpeedTest             * M W  Time speed of Matlab's various operations.
%   StructsFileTest         M    Test routines for reading and writing struct arrays to text files.
%   TimeBlankingTest        M    Synchronize computer to video frames.
%   TimingTest              M W  Many ways to time an interval. Some work at high priority.
%   TrolandTest             M W  Colorimetric conversions.
%   TwoBitFlickerTest       M    Test the two least significant bits of your grahics drivers.
%   WaitBlankingTest        M W  Measure how well WaitBlanking and SetClut synch to your display.
%   WavelengthSamplingTest  M W  Test conversion between representations of wavelength sampling information.

% Copyright (c) 1996-2003 by David Brainard & Denis Pelli
