function CursorTest
% CursorTest
% When this file is run as a function it works as expected. However, if
% the same code is run as a script, by commenting out line 1, above, 
% then the cursor remains visible, as tj describes below.
% 
% Thomas Jerde <thomasjerde@hotmail.com> reports difficulties in
% controlling the visibility of the cursor, "GetMouse seems to call
% ShowCursor. I want the cursor hidden, but every time i get the mouse
% position (which is constantly in a tracking program), it reappears.
% Backgrounding is off, so that's not responsible. So I call HideCursor
% every time I call GetMouse. There doesn't seem to be any flicker, so
% this is an acceptable solution. I also noticed that the hidden cursor
% appears if I click on a menu, a scroll bar, or if the cursor passes over
% the control strip at the bottom of the screen. Also, curiously, if I
% call HideCursor many times, it appears I have to call ShowCursor
% *almost* as many times to make it reappear. For example, if I call
% HideCursor 100 times, the cursor reappears when I call ShowCursor
% 80-some times. I'm confused. Of course, it's not really a problem (my
% experiment runs fine), but I still find it curious."
% 
% We believe that all of the strange symptoms are due to Thomas running
% his program as a script, rather than as a FUNCTION. We can't do anything
% about Matlab's interventions in script mode, but please report any
% unexpected behavior that occurs when running as a FUNCTION.
% psychtoolbox@yahoogroups.com

% 7/1/02 dgp Wrote it.

fprintf('CursorTest tests the hiding and showing of the cursor. At each step I''ll\n');
fprintf('say whether the cursor should be visible or not. If you note any discrepancy\n');
fprintf('please report it to the forum: psychtoolbox@yahoogroups.com\n\n');
fprintf('Cursor should now be hidden, while we call GetMouse repeatedly for 3 seconds.\n');
hidecursor;
t=getsecs;
while getsecs<t+3
	[x,y,button]=getmouse;
end
fprintf('Cursor should still be hidden. Please hit any key.\n');
GetChar;
showcursor;
fprintf('Called ShowCursor. Cursor should now be visible. Please hit any key.\n');
GetChar;
for i=1:1000
	hidecursor;
end
fprintf('Called HideCursor 1000 times. Should be hidden. Please hit any key.\n');
GetChar;
for i=1:999
	showcursor;
end
fprintf('Called ShowCursor 999 times. Should still be hidden. Please hit any key.\n');
GetChar;
for i=1:1
	showcursor;
end
fprintf('Called ShowCursor 1 more time. Cursor should now be visible. Please hit any key.\n');
GetChar;
hidecursor;
fprintf('Called HideCursor. Cursor should be hidden. Please hit any key.\n');
GetChar;
clear HideCursor;
fprintf('Called "clear HideCursor". Cursor should be visible. Please hit any key.\n');
GetChar;
screen(0,'openwindow');
screen('MatlabToFront')
hidecursor;
fprintf('Opened a window. Called HideCursor. Cursor should be hidden. Please hit any key.\n');
GetChar;
clear Screen;
fprintf('Called "clear screen". Cursor should be visible. Please hit any key.\n');
GetChar;
fprintf('Done. Hopefully the cursor came and went as it should.\n');
