% GetClicksTest
%
% Use GetClicks and GetChar at the same time.

% 3/13/97  dhb  Wrote it.
% 4/4/97  dgp  Announce success as such.
% 2/12/98  dgp  Updated to use CharAvail and GetChar.
% 3/12/98	dgp	Make sure Backgrounding is off.
% 3/31/98	dgp	More self explanatory.
% 3/28/99 dgp Turn off backgrounding.
% 4/24/02 awi Exit on PC with message.

if strcmp('PCWIN',computer)
    error('Win: GetClicksTest.m not yet supported.');
end


% NOTE: When BACKGROUNDING is enabled, Matlab removes all characters
% from the event queue before executing each Matlab statement, so
% CharAvail and EventAvail('keyDown') always report 0. We avoid this 
% problem by turning off BACKGROUNDING:

Screen('Preference','Backgrounding',0); % Until Matlab 5.2.1 this call was slow, requiring a disk access.

fprintf('Click (or double click) the mouse to proceed.\n');
while (1)
  [x,y,down] = GetMouse;
  if (down)
    clicks = GetClicks;
    fprintf('Got %g clicks.\n',clicks);
    break;
  end
end

fprintf('\nType ''p'' and click the mouse to proceed.\nIf this fails, type command-. (Hold apple-cloverleaf key down and hit period ".")\n');
FlushEvents('mouseUp','mouseDown','keyDown')
while (1)
  GetClicks;
  if CharAvail
    key=GetChar;
      if key=='p'
        fprintf('Success!\n');
        break;
     end
  end
end
