function GetSecsTest
% GetSecsTest adjusts the time-advancement rate of GetSecs to match
% that of GetTicks, i.e. the standard Macintosh 60.15 Hz tick counter.
% The Apple-default rate for GetSecs is generally accurate to about
% 10^-2. GetTicks, which is the time base for the time of day, seems
% to be accurate to within a few minutes a month, ie 10^-4.
% GetSecsTest adjusts the multiplier in the VideoToolbox Seconds.c to
% match the two rates to within 10^-4. You could time more ticks to
% achieve a better match, but I don't think the absolute accuracy of
% the tick counter warrants matching any more closely. Note that the
% SecondsMultiplier value is specific to the machine it was measured
% on.
% 
% If it is important to your application to have time advance at the
% same rate every time you run Matlab, then you may wish to compute
% this SecondsMultiplier only once, and to create a script that loads
% that specific value into the Screen Preference SecondsMultiplier,
% and to run that script at the beginning of every session. Note that
% this multiplier has no effect on the internal counter; it merely
% affects the conversion of the count to a time.
% 
% Screen Preference SecondsMultiplier stores the new value in the
% PsychTable, which persists until you quit Matlab. (It's not affected
% by Matlab'S CLEAR.)
%
% See Apple's "Technical Q&A HW31 - UpTime's values are consistently slow?"
% web http://developer.apple.com/qa/hw/hw31.html
%
% See TimingTest.

% 2/18/99	dgp Wrote it.
% 3/15/99	dgp Use the result to set SecondsMultiplier.
% 3/19/99	dgp Polished.
% 4/20/99	dgp Not affected by CLEAR.
% 12/22/99	dgp Added link to Apple's note on UpTime's slowness.
% 4/24/02 awi Exit on PC with message.

if strcmp('PCWIN',computer)
    error('Win: GetSecsTest.m not yet supported.');
end

clear s ss m
waitticks(0);getsecs;s=zeros(1,20);
for j=1:4
	for i=1:length(s)
		waitticks(1);
		s(i)=getsecs;
	end
	ss=sort(diff(s));
	n=3;
	m(j)=mean(ss((1+n):(end-n)))*60.15;	% discard n largest and smallest values
end
fprintf('Timed %g ticks. Rate of GetSecs is %.4f%.4f that of GetTicks.\n',length(s)*length(m),1/mean(m),std(m)/sqrt(length(m)));
oldM=Screen('Preference','SecondsMultiplier');
Screen('Preference','SecondsMultiplier',oldM/mean(m));
fprintf('Now changing the Screen Preference SecondsMultiplier from %.4f to %.4f \n',oldM,Screen('Preference','SecondsMultiplier'));
fprintf('to adjust the rate of GetSecs to match that of GetTicks.\n');
