function HelpTest(directory)
% HelpTest([directory]) asks for help on every file and folder
% within the specified folder (and subfolders). The default
% is the Psychtoolbox folder.

% Denis Pelli 19 July 1998
% 6/18/02 dgp Changed default from current directory to psychtoolbox directory.
% 6/29/02 dgp Use PsychtoolboxRoot to cope with user-changed folder name.

if nargin>1
	error('Usage: HelpTest([directory])');
end
oldDirectory=cd;
if nargin<1
	directory=PsychtoolboxRoot;
end
cd(directory);
help(directory);
dd=dir(directory);
for i=1:length(dd)
	if dd(i).isdir
		HelpTest(dd(i).name);	% folder
	else
		help(dd(i).name);		% file
	end
end
cd(oldDirectory);
