function LeakTest
% LeakTest measures any memory leakage associated with to opening and closing windows.

% 6/1/97	dgp Wrote it.
% 7/31/97	dgp Added more explanation to the print out.
% 8/2/97	dgp Cosmetic.
% 4/24/02 awi Exit on PC with message.

if strcmp('PCWIN',computer)
    error('Win: LeakTest not yet supported.');
end

fprintf('LeakTest: Measure any memory leakage associated with opening and closing windows.\n');
% allocate all variables before we start
n=5;
i=0;
free=1:n;
temp=1:n;
Bytes('Free');
window=Screen(0,'OpenWindow');
Screen(window,'Close');
for i=1:n;
	free(i)=Bytes('Free');
	temp(i)=Bytes('TempFree');
	window=Screen(0,'OpenWindow');
	Screen(window,'Close');
end
fprintf(1,'Report available free memory in Matlab''s heap and System''s "temporary" memory heap.\n');
fprintf(1,'iteration      heap  tempHeap\n');
free=free-free(1);
temp=temp-temp(1);
for i=1:n;
	fprintf(1,'%9d  %8d  %8d  free bytes re first time\n',i,free(i),temp(i));
end
if all(free==0) & all(temp==0)
	fprintf('Yay! ');
end
fprintf('Zeroes indicate no leakage.\n');
if any(temp~=0)
	fprintf('NOTE: Any process that''s active while we''re running may take\n');
	fprintf('or return "temporary" memory, so nonzero values for tempHeap are\n');
	fprintf('only a concern if they are consistently nonzero.\n');
end
