function LoopTest
% LoopTest
%
% Measures the variation in Matlab speed.  LoopTest uses only standard
% Matlab functions.
% 
% Current results (Matlab 5, PowerMac 6100) indicate that Matlab pauses
% for several milliseconds once or twice a second. This wreaks havok on
% any attempt to control a real-time process. This is not Matlab's fault.
% The pauses are due to Mac OS and device driver interrupts.
% 
% See RushTest.

% 4/12/97 dgp Wrote it.
% 4/15/97 dgp Updated.
% 4/24/97 dgp Renamed from LoopTest2 to LoopTest.

fprintf('Matlab %s\n',version);
v=version;
if str2num(v(1))<5
	fprintf('WARNING: On PowerMacs, Matlab 4''s CPUTIME returns nonsense.')
end
i=0;n=10000;t=zeros(1,n);cputime;
for i=1:n
	t(i)=cputime;
end
dt=diff(t)*1000;
fprintf('Time per iteration of a FOR loop, t(i)=cputime, in milliseconds.\n');
fprintf('%d iterations.\n',n);
fprintf('min %.2f, mean %.2f%.2f, max %.2f.\n',min(dt),mean(dt),std(dt),max(dt));
fprintf('Now plotting the variation in loop time over time.\n');
plot(t(2:length(t))-t(1),dt)
title('Variation in duration (of one iteration) over time')
xlabel('Time (s)');
ylabel('Duration (ms)');
figure(gcf)
