% PeekBlankingSimpleTest
%
% Simple program to demonstrate problem with peek blanking 
% on ATI Radeon 32 Mac Edition and perhaps other cards.  A
% modification to BlankingDuration seems to eliminate this problem.
%
% 10/7/02 dhb, ly  Wrote it.
% 2/19/04 awi  Added error exit in case of Win.

if IsPCWIN
    error('Win: PeekBlankingSimpleTest not yet supported');
end

% Clear out
clear all

% Set some parameters and allocate memory
maxFrames = 30000;
whichScreen = 1;
peeks = zeros(maxFrames,1);
times = zeros(maxFrames,1);
times2nd = zeros (maxFrames,1);

% Open, run loop, and close
w = Screen(whichScreen,'OpenWindow',0);
LoadClut(w,zeros(256,3));
Screen(w,'SetClut',zeros(256,3));
GetSecs;
Screen(w,'WaitBlanking');
for i = 1:maxFrames
	LoadClut(w,ones(256,3));
	[peeks(i),times(i)] = Screen(w,'PeekBlanking');
	times2nd(i) = GetSecs;
end
Screen(w,'Close');

% Plot blanking count and time differences
figure (1);
subplot(3,1,1);
plot(diff(peeks));
subplot(3,1,2);
plot(diff(times));
subplot(3,1,3);
plot(diff(times2nd));
