function PixTest
% PixTest assesses how well Screen 'Close' copes with unexpected pixelSize change.
% 
% WARNING: this test uses Screen 'ResolutionQuickly' to change the pixelSize
% without telling QuickDraw. This is dangerous stuff, not for the faint of heart.
% ResolutionQuickly is dangerous, liable to cause a crash. It's in a different 
% category from all other features of Screen.
% 
% As this is going out in the 2.5 release, PixTest runs fine on a G4 Powerbook, but crashes
% on a PowerMac 7500 upgraded with G4. This indicates that Screen.mex is not quite up
% to this stress at the moment. We'll update Screen.mex and/or PixTest when we track
% down the cause. However, don't fret; ResolutionQuickly is breaking the rules, so
% this crash is no indication of any fault in Screen.mex.

% 6/20/02 dgp Wrote it.
% 6/24/02 dgp Added warning.

fprintf('PixTest\n');
fprintf('Testing whether Screen Close can cope with unexpected pixelSize change.\n');
for s=Screen('Screens')
	fprintf('Screen %d\n',s);
	w=Screen(s,'OpenWindow',[],[],16);
	res=Screen(s,'Resolution');
	res.depthMode=128;
	Screen(s,'ResolutionQuickly',res);
	res2=Screen(s,'Resolution');
	fprintf('Used Screen ''ResolutionQuickly'' to change pixelSize from %d to %d, unbeknownst to QuickDraw. Shh.\n',res.pixelSize,res2.pixelSize);
	Screen(w,'Close');
end
fprintf('Success!\n');
