function PixelSizeTest
% WARNING! THIS MAY CRASH!
% PixelSizeTest repeatedly uses Screen('OpenWindow') to test every screen
% at every pixelSize. Repeatedly changing pixelSize used to crash Mac OS
% 7, before 7.6. If Matlab's Backgrounding is off, it works fine now on
% all Macs tested to date: PowerBook G4, Powerbook G3 Series, G3, and
% 6100. If Backgrounding is on, then PixelSizeTest crashes a PowerBook G4
% running Mac OS 9.2.2, a PowerBook G3 series running Mac OS 8.6, and a
% PowerMac running Mac OS 8.1. PixelSizeTest runs fine on a PowerMac 6100
% running Mac OS 8.6 and no foreign INITs, whether or not Backgrounding is
% enabled.
% 
% DIAGNOSIS: it's hard to know who to blame. It's an interaction of our
% code, MATLAB's backgrounding code, and QuickDraw. Presumably someone is
% make an assumption that someone else is violating. It's now moot because
% we have other compelling reasons for always keeping Backgrounding off.

% 4/8/98 dgp wrote it
% 5/23/99 dgp Mention conflict with Backgrounding.
% 6/2/99 dgp Add David's report, which indicates that the conflict is with Backgrounding, not
%            any particular version of the Mac OS.
% 6/10/99 dgp Add 6100 Mac OS 8.6 report.
% 2/4/00  dgp  Updated for Mac OS 9.
% 8/19/00 dgp  Cosmetic.
% 2/19/04 awi  Removed 16-bit test on Windows.

help PixelSizeTest
DescribeComputer;
n=10;
if Screen('Preference','Backgrounding')
	warning('Matlab Backgrounding is on. This test may crash. Please tell us: psychtoolbox@yahoogroups.com');
end
for i=1:n
	fprintf('%2d of %d repeats. ',i,n);
	for whichScreen=Screen('Screens');
		fprintf('screen %d, pixelSize',whichScreen);
        pixelSizes=Screen(whichScreen,'PixelSizes');
        if isPCWIN
            pixelSizes=setdiff(pixelSizes,16);
        end
		for pixelSize=pixelSizes
			fprintf(' %d',pixelSize);
			w=screen(whichScreen,'OpenWindow',[],[0 0 100 100],pixelSize);
			screen(w,'Close');
		end
		fprintf('. ');
	end
	fprintf('\n');
end
fprintf('Success!\n');
