% PopCharTest demonstrates an init conflict caused by PopChar Pro 1.3.3
% (latest version as of 2/25/02) with Matlab 5.2.1 under Mac OS 9.1. The
% symptom is associated with Screen DrawText. When PopChar Pro is present,
% requesting the optional second argument newY causes an internal Matlab
% error "Attempt to free previously freed memory".
% 
% I presume that PopCharPro intercepts the QuickDraw DrawText call and isn't
% as innocuous as it's meant to be, resulting in damage to Matlab's memory
% management code or data structure.
% 
% This test fails with PopCharPro, but succeeds with the old, free PopChar 2.7.2, 
% which is no longer available, alas.
% 
% CONCLUSION: Don't use PopChar Pro with Matlab.
% 
% Thanks to Frans Cornelissen for help in tracking this down.

% 2/24/02 dgp Wrote it.
% 8/1/02  dgp Added result of testing with PopChar 2.7.2.

window=Screen(0,'OpenWindow',[],[100 100 200 200]);
% screen(window,'TextFont','Bookman');
[newX,newY]=Screen(window,'DrawText','Hello world',10,100)

Screen('CloseAll');
