function ResolutionQuicklyTest
% ResolutionQuicklyTest
% Exercises Screen ResolutionQuickly. It tries all the "safe" resolutions.
% The colorful mess that you see is normal and expected. It is displaying
% the contents of the graphics card memory which were drawn at another
% resolution, i.e. it's all been remapped (scrambled). Screen
% ResolutionQuickly is a quick driver-level control. Screen Resolution is
% the corresponding (slow) high-level control that tidies everything up
% before returning control back to you.
% 
% WARNING: if you hit Command-period to interrupt ResolutionQuicklyTest
% before it's done, the screen will NOT be restored. ResolutionQuickly
% changes things in a way that Screen did not envision. Screen could be
% enhanced to cope with it, but that doesn't seem urgent, since
% ResolutionQuickly is a fairly exotic tool. However, if you blindly type
% Command-zero (to bring the command window forward) and then type
% 	clear screen
% you probably will get restoration. The magical phrase
% 	screen(0,'resolution',screen(0,'resolution'))
% will definitely work.
% 
% Also see ResolutionTest, Screen 'Resolution' and 'ResolutionQuickly'.

% 4/12/02 dgp Wrote it.
% 4/17/02 dgp SetClut.
% 4/24/02 awi Exit on PC with message.
% 4/29/02 dgp When not supported, the message should be an ERROR, not just fprintf.
% 6/20/02 dgp Make ClutDefault based on pixelSize, not device, since QuickDraw's info is stale.
% 6/20/02 dgp Keep the same pixelSize throughout.
% 2/19/02 awi Cosmetic chantes to Win conditional.

if IsPCWIN
	error('Win: ResolutionQuicklyTest not supported.')
end

createWindow=1;
fprintf('ResolutionQuicklyTest\n');
fprintf('Will now try all the safe resolutions on each screen.\n');
for which=Screen('Screens');
	DescribeScreen(which);
	pixelSize=Screen(which,'PixelSize');
	if createWindow
		w=Screen(which,'OpenWindow',[],[0 0 400 100]);
		Screen(w,'TextSize',48);
	end
	ress=Screen(which,'Resolutions');
	oldRes=Screen(which,'ResolutionQuickly'); % save
	for i=1:length(ress)
		% Let's keep the same pixelSize. SetClut is tricky when pixelSize changes.
		j=find(pixelSize==[ress(i).depths.pixelSize]);
		if ~isempty(j) & ress(i).safe
			j=j(1);
			ress(i).depthMode=ress(i).depths(j).depthMode;
			ress(i).pixelSize=ress(i).depths(j).pixelSize;
			Screen(which,'ResolutionQuickly',ress(i));
			Screen(which,'Gamma',[0:255]',8); % use 8-bit gamma table for maximum compatibility.
			Screen(which,'SetClut',ClutDefault(ress(i)));
			fprintf('Display mode %3d: %dx%d, pixelSize %d\n',ress(i).mode,ress(i).width,ress(i).height,ress(i).pixelSize);
			if createWindow
				Screen(w,'FillRect');
				Screen(w,'DrawText','Hello world!',10,58);
			end
			WaitSecs(1);
		end
	end
	Screen(which,'ResolutionQuickly',oldRes); % restore
	if createWindow
		% IMPORTANT: restore the same resolution as when you called OpenWindow before calling Close.
		Screen(w,'Close');
	end
% 	Screen(which,'Resolution',oldRes); % force redraw of Screen
end
DescribeScreen(-1);
fprintf('Success!\n');
