function ShowtimeTest
% Test Showtime.mex. Create and display a QuickTime movie.
% 
% Example: Specifying only some frames within a media's frame set to
% be included in a track
% 
% This example will create either of two different movies, depending
% on the setting of "fullLength". If fullLength is true, then we
% create an 8-frame moving-bar movie. Otherwise we create a movie with
% 3 frames using the 3rd to the 6th frame of the same movie data used
% in the first.  The only change is in the parameters supplied to the
% function Showtime 'VideoTrackSamplesSet'.
% 
% Denis Pelli, 11/99

% 11/7/99  dgp  Wrote it, based on Beau Watson's Mathematica qtWrite tutorial.
% 11/9/99  dgp  Put movie in root directory.
% 11/12/99 dgp  Put movie on desktop.
% 4/24/02  awi  Cosmetic changes to comments.  Exit on PC with message.

if strcmp('PCWIN',computer)
    error('Win: Showtime not yet supported.');
end


clear Showtime	% use latest Showtime.mex
fullLength=1;

% window
whichScreen=0;
window=Screen(whichScreen,'OpenWindow');
white=GrayIndex(window,1);
black=GrayIndex(window,0);
gray=GrayIndex(window,0.5);
if round(gray)==white
	gray=black;
end
inc=white-gray;
Screen(window,'FillRect',gray);

% grating
frames=90;
[x,y]=meshgrid(-50:50,-50:50);
angle=17*pi/180; % 17 deg orientation; change it to whatever you want.
f=0.03*2*pi;
rate=FrameRate(window);
hz=2;
a=cos(angle)*f;
b=sin(angle)*f;
driftingGabor=uint8(zeros(size(x)));
driftingGabor(:,:,frames)=driftingGabor;
for i=1:frames
 	m=exp(-((x/25).^2)-((y/25).^2)).*sin(a*x+b*y+2*pi*(i/rate)*hz);
	t=4*(i-frames/2)/frames;
	driftingGabor(:,:,i)=gray+inc*m*exp(-t^2);
	Screen(window,'PutImage',driftingGabor(:,:,i));
end
Screen(window,'Close');

% Save the QuickTime movie file in the user's desktop.
s=matlabroot;
n=findstr(filesep,s);
root=s(1:n(1));
cd(fullfile(root,'Desktop Folder',''));
filename='DriftingGrating.mov';

% Make the movie, and save it to disk as a QuickTime movie file.
bits=Screen(whichScreen,'PixelSize');
rows=size(driftingGabor,1);
cols=size(driftingGabor,2);
trackTimescale=600;
frameDuration=round(trackTimescale/FrameRate(0)); 
% frameDuration=round(trackTimescale/frames); 
preload=1;
window=Screen(whichScreen,'OpenWindow');
movie=Showtime('MovieCreate',filename,window);
Showtime('VideoTrackCreate',movie,rows,cols,trackTimescale,preload);
Showtime('VideoMediaCreate',movie);
Showtime('VideoMediaSamplesAdd',movie,driftingGabor,bits,frameDuration);
Showtime('VideoMediaSave',movie);
if fullLength
	trackStartTime=[];	% default is 0
	startInMedia=[];	% default is 0
	durationInMedia=[];	% default is full length
else
	trackStartTime=0;
	startInMedia=frameDuration*2; 		% third frame
	durationInMedia=frameDuration*3;	% use 3 frames
end
Showtime('VideoTrackSamplesSet',movie,trackStartTime,startInMedia,durationInMedia);
Showtime('VideoTrackSave',movie);
Showtime('MovieUserDataAdd',movie,'A movie demo.','inf');
Showtime('MovieSave',movie);
Screen(window,'Close');
fprintf('Your new %d-bit QuickTime movie "%s" is on your desktop.\n',bits,filename);

% show the movie
movie=Showtime('GetFromFile',filename);
hz=Showtime('Rate',movie);
fprintf('%.1f Hz rate\n',hz);
% Showtime('Rate',movie,'screenRate');
% hz=Showtime('Rate',movie);
% fprintf('%.1f Hz screenRate\n',hz);
if 0
	%sound=Showtime('Sound',array)
	sound=Showtime('GetFromFile','droplet');
	Showtime('Add',movie,sound);
	Showtime('Dispose',sound);
end
% error=Showtime('SaveToFile',movie)
Showtime('LoadIntoRam',movie);
window=Screen(whichScreen,'OpenWindow');
Showtime('Window',movie,window);
% Showtime('Scale',movie,1);
% Showtime('Rate',movie,FrameRate(whichScreen));
% lut=ClutDefault(window);
% Showtime('SetClut',window,lut);
for i=1:5;
	Showtime('Show',movie);
end
% Showtime('Fill',movie,255);
% WaitSecs(0.5);
Showtime('Dispose',movie);
Screen(window,'Close');
