function TearTest
% From: Anthony Helou <anthonyhelou@yahoo.com> 
% Date: TueAug6,2002 5:12 pm
% Subject: Tear using Loadclut and ATI Radeon 7200
%  
% Hi
% 
% I have been experiencing a problem while generating a movie on 
% an ATI Radeon Video card.
% 
% ***Power Mac G4/500, Mac OS 9.1  **************************
% G4, 500 MHz, memory bus 100 MHz, 79.847 Mflop/s
% Psychtoolbox 2.51, 5 July 2002, Matlab 5.2.1.1421
% FileSharing is on.
% *** Screen 0 *********************************************
% ATI Rage128Pro, AGP
% ATY,Rage128Ps (.Display_Rage128 version 1.0f12) in slot SLOT-A
% 8 bit dacs. 1280x1024 75 Hz. 
% (56,60,65,67,70,72,75,76,85,90,100,120 Hz avail)
% *** Screen 1 **********************************************
% ATI Radeon 7200, retail, PCI
% ATY,RADEONp (.Display_RADEON version 1.0f52) in slot SLOT-B
% 10 bit dacs. 640x480 75 Hz. 
% (56,60,65,67,70,72,75,76,85,90,100,120 Hz avail)
% ***********************************************************
% 
% The problem I am experiencing is in the form of a tear 1/3 of the
% distance from the top of the image ( while runing the screen at 65 Hz).
% The tear is still evident even at diferent monitor settings ; however,
% at a different location.
% 
% I did write a test progam that I have included below to isolate and
% demonstrate the error. In the test program, I tested loading a new clut
% using setclut, setclut along with waitblanking, and loadclut. All
% variations show the tear.

screennum=0;
y = 1024; % Resolution 1280 * 1024
n = 1280; 
MyData.totalimages = 250; % number of images to be shown
bits = 8; 
% Generating image to be shown
stimulus = randperm((2^10) - 1);
stimulus = repmat(stimulus,y,1);
% Generating a random set of cluts -- 8 bits per pixel
MyData.rand_clut = zeros(256,3,MyData.totalimages);
for j = 1:MyData.totalimages
	MyData.perm_clut = (randperm((2^bits) - 1)');
	for i = 1:3
		MyData.rand_clut(2:256,i,j) = MyData.perm_clut;
	end
end
%%%%%%%%%%%%%%%%%%%%%% SETCLUT %%%%%%%%%%%%%%%%%%%%%%
window = screen ( screennum, 'openwindow',128);
SCREEN(window, 'Putimage',stimulus);
for i = 1:MyData.totalimages
	screen(window,'setclut',MyData.rand_clut(:,:,i));
end
%%%%%%%%%%%%%%%%%%%%%% BLANK %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Generating blank image 
blank = ones ( y,n);
blank = (2^bits)/2 * blank;
SCREEN(window, 'Putimage',blank);
waitsecs(2);
%%%%%%%%%%%%%%%%%%%%% SETCLUT + WAIT BLANKING %%%%%%%%%%%%%%%%
SCREEN(window, 'Putimage',stimulus);
for i = 1:MyData.totalimages
	screen(window,'waitblanking');
	screen(window,'setclut',MyData.rand_clut(:,:,i));
end
%%%%%%%%%%%%%%%%%%% BLANK %%%%%%%%%%%%%%%%%%%%%%%%%%%%
SCREEN(window, 'Putimage',blank);
waitsecs(2);
%%%%%%%%%%%%%%%%%%% LOADCLUT TEST %%%%%%%%%%%%%%%%%%
% Generating random set of cluts -- 10 bits per pixel
MyData.rand_clut = zeros(256,3,MyData.totalimages);
for j = 1:MyData.totalimages
	MyData.perm_clut = (randperm((2^10) - 1)');
	for i = 1:3
		MyData.rand_clut(2:256,i,j) = MyData.perm_clut(2:256);
	end
end
SCREEN(window, 'Putimage',stimulus);
for i = 1:MyData.totalimages
	loadclut(window,MyData.rand_clut(:,:,i),0,10);
end
screen('closeall');
