function TimeBlankingTest
% TimeBlankingTest
%
% Test timing of the code that synchs to blanking. 
% All timing methods should give approximately the same answer.
% 
% Each video frame ends with a blanking pulse, sent from your 
% computer to your monitor. All frame counting and 
% synchronization is done by reference to the beginning of that
% blanking pulse.
%
% Thanks to David Ferster, whose documentation of problems
% (now fixed) led to this demo.

% 6/11/94	dhb	Wrote it.
% 1/26/97	dgp	Minor editing, for more accurate timing.
% 1/27/97   dhb	More minor editing, for yet more accurate timing.
%           dhb	Deleted Pelli's description of TIMER bug, since it
%           	  is now fixed. 
% 1/29/96   dhb	Denis realized we need to precall GetSecs to
%              	account for its load time.  Added this. 
% 3/3/97    dhb	Cosmetic editing.               
% 3/8/97    dgp	Updated.            
% 3/9/97    dgp	Use Screen('Screens') to iterate over all screens. 
% 3/15/97   dgp	Ask user for permission to turn off filesharing.
% 2/12/98   dgp	Name conflict. Change "version" to driverVersion.
% 3/11/98   dgp	driverVersion was number, now string.
% 8/12/98   dgp	added FrameRate.
% 3/22/99   dgp	don't bother to turn off Filesharing or screensaver, since they don't seem
%               to affect this program.
% 4/24/02   awi Exit on PC with message.

if strcmp('PCWIN',computer)
    error('Win: TimeBlankingTest not yet supported.');
end


% Turn off things that might slow us down.
% fsWasOn=FileShare(-3,1);
% adWasOn=AfterDark(0);

clear all;
fprintf('TimeBlankingTest\n');
DescribeComputer

for screenNumber=Screen('Screens')	% test every screen
	% Describe video card
	DescribeScreen(screenNumber);
	DescribeScreenPrefs(screenNumber);
	
	fprintf('%.1f Hz frame rate returned by FrameRate.\n',FrameRate(screenNumber));

	% Preload all functions, to avoid delays later.
	GetSecs;WaitSecs(0);
	
	% 1. Time a fixed number of frames
	for nWait=[2 20 200]
		Screen(screenNumber,'WaitBlanking');
		s=GetSecs;
		missedFrames=Screen(screenNumber,'WaitBlanking',nWait);
		s=GetSecs-s;
		frames=nWait+missedFrames;
		fprintf('%.1f Hz frame rate measured by WaitBlanking(%g). Missed %g frames out of %g.\n',frames/s,frames,sum(missedFrames),frames);
	end
	
	% 2. Time a fixed number of frames.  This time we
	% loop on WaitBlanking, rather than using one call to wait. 
	% This makes no difference.
	nWait=100;
	missedFrames=zeros(nWait,1);
	Screen(screenNumber,'WaitBlanking');
	s=GetSecs;
	for i=1:nWait
		missedFrames(i)=Screen(screenNumber,'WaitBlanking');
	end
	s=GetSecs-s;
	frames=nWait+sum(missedFrames);
	fprintf('%.1f Hz frame rate measured by %g calls to WaitBlanking(1). Missed %g frames out of %g.\n',frames/s,frames,sum(missedFrames),frames);
	
	% 3. Use PeekBlanking to count frames for fixed time.
	Screen(screenNumber,'WaitBlanking');
	[frame0,s0]=Screen(screenNumber,'PeekBlanking');
	WaitSecs(0.5);
	[frames,s]=Screen(screenNumber,'PeekBlanking');
	frames=frames-frame0;
	s=s-s0;
	fprintf('%.1f Hz frame rate measured by PeekBlanking over %g s.\n',frames/s,s);
end
DescribeScreen(-1); % bottom line for table.

% Restore state
% FileShare(fsWasOn);
% AfterDark(adWasOn);
