function [uEst,varEst] = FitCumNormYN(inputs,nYes,nNo)
% [uEst,varEst] = FitCumNormYN(inputs,nYes,nNo)
%
% Fits a cumulative normal function to the passed yes-no data.
% Requires the optimization toolbox.
%
% INPUTS:
%   inputs:   Input levels
%   nYes:     Number of yes responses at the corresponding input level
%   nNo:      Number of no responses at the corresponding input level
% OUTPUTS:
%   uEst
%   varEst
%
% See also: FitWeibTAFC, FitFitWeibYN, FitWeibAlphTAFC, FitLogitYN
%
% 9/22/93   jms  Created from FitWeibullYN.
% 2/8/97    dhb  Cleaned up and added some comments.
%                Check that optimization toolbox is present.
% 10/4/00   dhb  Fixed bugs along lines suggested by Keith Schneider.
%                Case of uInitial = 0 wasn't handled properly, and
%                variance search limits were set based on mean.

% Set up an initial guess
uInitial = mean(inputs);
varInitial = std(inputs)^2;

% Stuff guess into a vector
x0(1) = uInitial;
x0(2) = varInitial;

% Compute fit.  Sometimes fitting twice improves result.
if (exist('constr') ~= 2)
	error('FitCumNormYN requires the optimization toolbox');
end
options = foptions;
vlb = [-1e10 1e-10*varInitial];
vub = [1e10 1e10*varInitial];
x1 = constr('CumNormYNFitFun',x0,options,vlb,vub,[],inputs,nYes,nNo);
x = constr('CumNormYNFitFun',x1,options,vlb,vub,[],inputs,nYes,nNo);

% Extract fit parameters parameters
uEst =   x(1);
varEst = x(2);
