function [DataMat,NFrontPoints,NBackPoints,chAddSubZeros,NZPoints] = AddSubZeros(AddSubStatus,DataMat,NFrontPoints,NBackPoints,chAddSubZeros,NZPoints)
%
%	AddSubZeros.m

% 	function [DataMat,NFrontPoints,NBackPoints,chAddSubZeros,NZPoints] = ...
% 	AddSubZeros(AddSubStatus,DataMat,NFrontPoints,NBackPoints,chAddSubZeros,NZPoints)
% 	Hier werden keine Nullen, sondern die Start- oder entsprechend Endwerte hinzugefuegt !!!
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<6; NZPoints=[]; end
if nargin<5; chAddSubZeros=[]; end
if nargin<4; NBackPoints=[]; end
if nargin<3; NFrontPoints=[]; end
if nargin<2; DataMat=[]; end
if nargin<1; AddSubStatus=1;DataMat=ones(128,250); end

[chAddSubZeros]=IfEmptyInputBo('Do you want to add zeros ?',[],chAddSubZeros,1,1);
if ~chAddSubZeros;return; end

[AddSubStatus]=IfEmptyInputSpecVal(AddSubStatus,[1 -1],1,...
			['Do you want to\n'],...
			['add                                [+1]'],...
			['or subtract zeros ?                [-1]']);			

[NChan,NPoints]=size(DataMat);

if AddSubStatus==1
	
	NZPointsDef=max(1024,2.^nextpow2(NPoints));
	fprintf('\n');clc;
	if isempty(NZPoints)
		fprintf(1,'Number of time points: %g !\n\n',NPoints);
		[NZPoints]=IfEmptyInputVal(['Please insert the number of time points'],['to filter ! (the rest will be filled with zeros)'],NZPoints,NZPointsDef);
	end
	NFPoints=NZPoints-NPoints;
	if (round(NFPoints./2)).*2==NFPoints
		NFrontPoints=NFPoints./2;
	else
		NFrontPoints=(NFPoints+1)./2;
	end
	NBackPoints=NZPoints-NFrontPoints-NPoints;
	
	%=====Hier werden keine Nullen, sondern die Start- oder entsprechend Endwerte hinzugefuegt !!!
	DataMatTmp=ones(NChan,NZPoints);
	for i=1:NChan
		DataMatTmp(i,1:NFrontPoints)=DataMat(i,1).*DataMatTmp(i,1:NFrontPoints);
		DataMatTmp(i,NPoints+NFrontPoints+1:NZPoints)=DataMat(i,NPoints).*DataMatTmp(i,NPoints+NFrontPoints+1:NZPoints);
	end

	DataMatTmp(:,NFrontPoints+1:NFrontPoints+NPoints)=DataMat;

elseif AddSubStatus==-1
	
	[NFrontPoints]=IfEmptyInputValInt(['Plesse insert the number'],['of frontal points to subtract:'],NFrontPoints,[],0,NPoints);
	[NBackPoints]=IfEmptyInputValInt(['Please insert the number'],['of back points to subtract:'],NBackPoints,[],0,NPoints-NFrontPoints);
	if NFrontPoints+NBackPoints==NPoints; DataMat=[]; return; end
	DataMatTmp=DataMat(:,NFrontPoints+1:NPoints-NBackPoints);
end
DataMat=[]; DataMat=DataMatTmp; DataMatTmp=[]; 

return;
			
