%==================================================================
%==================================================================
clear all;
%
%	BatchAudite.m
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	Markus Junghoefer	[2003]
%
%
%	Function definition
%	
%
%==================================================================
TRStatus=1;
[DefFilePath]=SetDefPath('r','*.RAW')
[NNetFiles,RAWFileMat,NonUse,BatchFilePath]=ReadFileNames([],DefFilePath,'Choose RAW files:');
if NNetFiles==0; return; end
SetDefPath('w',BatchFilePath);

[UseOverAllGainFileStatus]=IfEmptyInputBo('Do you want to use one special gain and one special zero file ?',[],[],1,1);

if UseOverAllGainFileStatus
    DefFilePath=SetDefPath(1,'*.Gain');
    [GainFile,GainPath,GainFilePath]=ReadFilePath([],DefFilePath,'Please choose the over all gain file:');
    SetDefPath(2,GainPath);
    DefFilePath=SetDefPath(1,'*.Zero');
    [ZeroFile,ZeroPath,ZeroFilePath]=ReadFilePath([],DefFilePath','Please choose the over all zero file:');
    if GainFile==0; GainFile=[]; GainPath=[]; GainFilePath=[]; end
    if ZeroFile==0; ZeroFile=[]; ZeroPath=[]; ZeroFilePath=[]; end
else
    GainFilePath=[];
    ZeroFilePath=[];
end

SampRate=[];
for FileInd=1:NNetFiles
    [NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RAWFileMat,FileInd);
    [NoUse,NoUse,NoUse,NoUse, ...
            NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, ...
            SampRateTmp,NChan]=ReadRAWHeader(NetFilePath);
    if ~isempty(SampRate)
        if SampRateTmp~=SampRate
            error('It is not possible to filter in batch mode because of different samp rates in different files !')
        end
    end
    SampRate=SampRateTmp;
end

%===============Transform data file format=======================
[TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20);

%[FilterFileMat]=FilterStopNetFile(NetFileMat,StopN,StopFrequ,ch_ChooseChannelInd,ChanStatusVec,PlotStatus, ...
%                                  ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,NFrontPoints,NBackPoints);
ch_ChooseChannelInd=0;
ChanStatusVec=ones(NChan,1);
PlotStatus=0;
ch_AddSubZeros=0;
NZPoints=[];
MaxMemory=100;
%====================================Stopband Filter 49-51 Hz====================================
[FilterTAWFileMat]=FilterStopNetFile(TAWFileMat,6,[49 51],ch_ChooseChannelInd,ChanStatusVec,PlotStatus, ...
    ch_AddSubZeros,NZPoints,TRStatus,MaxMemory);       

%[EGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHistNew(NetFileMat,TRStatus,...
%PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
%NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,DMeanSampleStatus,IntTrig)
[EGISFileMat]=TransNetGeoHist(FilterTAWFileMat,TRStatus,-251,1375,1,GainFilePath,ZeroFilePath,0,[],[],[],180,[],[],[],9)

%===============CalcAutoEditMat ohne avg ref EEG und ohne flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd);
[AEMFilePathMat]=CalcAutoEditMat(EGISFileMat,[],0,[],1,[],[],1,8,0,0);

%======Suche nach schlechten Kanaelen ==================================
%FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus);
FindBadChan(AEMFilePathMat,3,1);

%======Suche nach schlechten trials ==================================
% [AWEFileMat]=FindBadChanTrial(FilePathMat,AWELimesFac,BatchStatus);
FindBadChanTrial(AEMFilePathMat,2.5,1);

%===============CalcAutoEditMat mit avg ref EEG und mit flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd);
[AEMFilePathMat]=CalcAutoEditMat(EGISFileMat,[],1,1,1,[],[],0,8,1,1,[],[],9,12);