%==================================================================
%==================================================================
clear all;
%
%	BatchCombineLPPMovie1s.m
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%
%
% Fr dig 2 mssen zwei dinge gendert werden
% 1: [FilterEGISFileMat]=TransNetGeoHistIAPS(FilterTAWFileMat,TRStatus,83,84,1,GainFilePath,ZeroFilePath,0,[],2)
%  letzte Zahl legt din fest
% 2: line 530 und 531 	in in TransNetGeoHistIAPS.m

% 		TrialVecTmp([1:2:length(CondVec)-1])=TrialVec;
% 		TrialVecTmp([2:2:length(CondVec)])=TrialVec+83;	; ndern zu
% 		
% 		TrialVecTmp([2:2:length(CondVec)])=TrialVec;
% 		TrialVecTmp([1:2:length(CondVec)-1])=TrialVec-83;	
		
% 		TimeMsVecTmp([1:2:length(CondVec)-1])=TimeMsVec;
%		TimeMsVecTmp([2:2:length(CondVec)])=TimeMsVec+83*1000/SampRate; ndern zu
%
% 		TimeMsVecTmp([2:2:length(CondVec)])=TimeMsVec;
%		TimeMsVecTmp([1:2:length(CondVec)-1])=TimeMsVec-83*1000/SampRate; 
%=================================================================
%==================================================================

TRStatus=1; % wird bergeben in TransRawTaw(RAWFileMat,TRStatus,20);

%***************** TeilI: Batch-file******************************
%**************Read files names****************
fid=0;
		[FileTmp,PathTmp]=uigetfile('*.*','Open batch file: ',0,0);
			FilePathTmp=[PathTmp,FileTmp];
			[fid] = fopen(FilePathTmp, 'r');
			NFiles=0;
		while feof(fid) == 0;
		NFiles=NFiles+1;
%********************************************************
%****  first file     ********************
		line=fgetl(fid);
		RawFilePath=line;
		GainFilePath=strrep(RawFilePath, '.RAW' , '.GAIN');
		ZeroFilePath=strrep(RawFilePath, '.RAW' , '.ZERO');
			if NFiles==1
				RAWFileMat=char(RawFilePath);
				GAINFileMat=char(GainFilePath);
				ZEROFileMat=char(ZeroFilePath);
			else
				RAWFileMat=char(RAWFileMat,RawFilePath);
				GAINFileMat=char(GAINFileMat,GainFilePath);
				ZEROFileMat=char(ZEROFileMat,ZeroFilePath);
			end
%********************************************************
		end		
		status = fclose(fid);
		RAWFileMat;
		GAINFileMat;
		ZEROFileMat;
		[NNetFiles,N]=size(RAWFileMat);
%********************************************************
%*************** Ende TeilI: Batch-file*************************
%********************************************************

%===============FilterNetFile====================================
%Filter 50 Hz LowPass
ch_LowPassFilt=1;
ch_HighPassFilt=0;
SampRate=[];
if ch_LowPassFilt | ch_HighPassFilt
	for FileInd=1:NNetFiles
		[NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RAWFileMat,FileInd);
		[NoUse,NoUse,NoUse,NoUse, ...
		NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, ...
		SampRateTmp,NChan]= ReadRAWHeader(NetFilePath);
		if ~isempty(SampRate)
			 if SampRateTmp~=SampRate
				error('It is not possible to filter in batch mode because of different samp rates in different files !')
			end
		end
		SampRate=SampRateTmp;
	end
end

HighDefFreqsMat=[SampRate 3 0];
HighDefRipMat=[3 45];
LowDefFreqsMat=[SampRate 50 60]; 
LowDefRipMat=[3 45];
ch_ChooseChannelInd=0;
ChanStatusVec=ones(NChan,1);
PlotStatus=0;
ch_AddSubZeros=0;
NZPoints=[];

[ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat] = ...
GetHighLowFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
ch_LowPassFilt,ch_HighPassFilt);

%=============================================================
%===============Transform data file format=======================
[TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20);

%===============FilterNetFile====================================
[FilterTAWFileMat]=FilterNetFile(TAWFileMat,ch_LowPassFilt,LowB,LowA,...
ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat,...
ch_ChooseChannelInd,ChanStatusVec,PlotStatus,ch_AddSubZeros,NZPoints,TRStatus);
DeleteFileMat(TAWFileMat);

%=============================================================
% [EGISFileMat,NetFileMat]=TransNetGeoHistIAPS(NetFileMat,TRStatus,...
% PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
% NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,DMeanSampleStatus,TrialDist)
TRStatus


FilterTAWFileMatTmp=FilterTAWFileMat;
		[MM,N]=size(FilterTAWFileMatTmp);

for FileInd=1:NNetFiles
		[NoUse,NoUse,FilterTAWFileMat]=GetFileNameOfMat(FilterTAWFileMatTmp,FileInd);
		[NoUse,NoUse,GainFilePath]=GetFileNameOfMat(GAINFileMat,FileInd);
		[NoUse,NoUse,ZeroFilePath]=GetFileNameOfMat(ZEROFileMat,FileInd);
	
		[FilterEGISFile]=TransNetGeoHistIAPS(FilterTAWFileMat,TRStatus,24,200,1,GainFilePath,ZeroFilePath,0,[],1,[],117,[],[],[],250)

		FilterEGISFileMat(FileInd,:)=(FilterEGISFile)
end		
FilterEGISFileMat;
		[MM,N]=size(FilterEGISFileMat);
DeleteFileMat(FilterTAWFileMat);



