function BatchJens(MergeStatus,ExportDisk,SubjIn,CorrECGFlag,FilterFlag,OverwriteStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global MsiFilePath
if nargin<6; OverwriteStatus=[]; end
if nargin<5; FilterFlag=[]; end
if nargin<4; CorrECGFlag=[]; end
if nargin<3; SubjIn=[]; end
if nargin<2; ExportDisk=[]; end
if nargin<1; MergeStatus=[]; end

if isempty(MergeStatus); MergeStatus=1; end %1 = TransMsiContSess + Merge; 0 TransMsiContSess only; 2 = Merge only
if isempty(ExportDisk); ExportDisk=3; end    
if isempty(CorrECGFlag); CorrECGFlag=1; end
if isempty(FilterFlag); FilterFlag=1; end
if isempty(OverwriteStatus); OverwriteStatus=0; end

%==================================================================
%==================================================================
%
%	BatchJens.m
%
%	Markus Junghoefer	[2001]
%
%
%	Function definition
%	
%
%
%
%
%=================================================================
%==================================================================
UnixStr=['lspdf -posted'];
[LsPdfStatus,LsPdfResult]=unix(UnixStr)
Tmp=findstr(LsPdfResult,'"');
if length(Tmp)>4
    LengthTmp=length(Tmp)
    LsPdfResult=LsPdfResult
end
HostName=lower([LsPdfResult(Tmp(3)+1:Tmp(4)-1)]);
fprintf(1,['Data on host: ',HostName,'\n']);
HardDiskName=[LsPdfResult(Tmp(1)+1:Tmp(2)-1)];
fprintf(1,['Data on hard disk: ',HardDiskName,'\n']);
UnixStr=['get_pdfs -u -x'];
[GetPdfStatus,GetPdfResult]=unix(UnixStr);
TmpP=findstr(GetPdfResult,'-P');
TmpS=findstr(GetPdfResult,'-S');
Tmps=findstr(GetPdfResult,'-s');
Tmpr=findstr(GetPdfResult,'-r')
Tmpp=findstr(GetPdfResult,'-p');
NMsiFiles=length(TmpP);
GetPdfResult

DeleteOrigFileStatus=0;
DeleteNoiseFileStatus=0;
PatConStatus=1; %Controls
PatConStr=int2str(PatConStatus);
for FileInd=1:NMsiFiles
    MsiSession=[GetPdfResult(Tmps(FileInd)+3:Tmpr(FileInd)-2)];   
    SessVec(FileInd)=str2num(MsiSession(11:12)).*60+str2num(MsiSession(14:15));
end
[MinSess,MinSessInd]=min(SessVec);
[MaxSess,MaxSessInd]=max(SessVec);
MinInd=find(SessVec==MinSess);
MaxInd=find(SessVec==MaxSess);
SessVec(MinInd)=ones(size(MinInd));
if MaxSess>MinSess
    SessVec(MaxInd)=2.*ones(size(MaxInd));
    NFilesInSessVec=zeros(2,1);
else
    NFilesInSessVec=zeros(1,1);
end
SesFilePathMat1=[];
SesFilePathMat2=[];
AEMFilePathMat1=[];
AEMFilePathMat2=[];
for FileInd=1:NMsiFiles
    ReplicateStatus=0;
    MsiPatient=[GetPdfResult(TmpP(FileInd)+3:TmpS(FileInd)-2)];
    SubjStr=MsiPatient(8:9);
    Subj=str2num(SubjStr)
    fprintf(1,'\n')
    fprintf(1,['\n MsiPatient = ',MsiPatient]);
    MsiScan=[GetPdfResult(TmpS(FileInd)+3:Tmps(FileInd)-2)];
    MsiSession=[GetPdfResult(Tmps(FileInd)+3:Tmpr(FileInd)-2)];
    MsiSessionTmp=[MsiSession(2:9),'@',MsiSession(11:15)];
    MsiRun=[GetPdfResult(Tmpr(FileInd)+3:Tmpp(FileInd)-2)];
    if FileInd<NMsiFiles
        MsiFile=deblank([GetPdfResult(Tmpp(FileInd)+3:TmpP(FileInd+1)-2)]);
    else
        MsiFile=deblank([GetPdfResult(Tmpp(FileInd)+3:length(GetPdfResult)-2)]);
    end
    PreTrigInt=99;
    PostTrigInt=300;
    NDefTrials=108;
    %===========Scan===============
    MsiScan=MsiScan
    Scan=MsiScan;
    %===========Session===============
    Session=SessVec(FileInd);
    NFilesInSessVec(Session)=NFilesInSessVec(Session)+1
    %===========Run===============
    Run=str2num(MsiRun);
    DirStr='REC';
    MsiPath=['/export/',HostName,filesep,HardDiskName,'/msi_data'];
    MsiPath=[MsiPath,filesep,MsiPatient,filesep,MsiScan,filesep,MsiSessionTmp,filesep,MsiRun];
    MsiFilePath=[MsiPath,filesep,MsiFile]
    NoiseFlag=1;
    if ~isempty(findstr(MsiFile,',n'))
        fprintf(1,'\n\n')
        fprintf(1,['MsiFile is already noise reduced: Disable noise reducer; NoiseFlag=0']); 
        NoiseFlag=0;
    end 
    if ~isempty(findstr(MsiFile,',f'))
        fprintf(1,'\n\n')
        fprintf(1,['MsiFile is already filtered: Disable filterer; FilterFlag=0']); 
        FilterFlag=0;
    end
    fprintf(1,'\n\n')
    fprintf(1,['MsiFilePath: ',MsiFilePath]);
    MsiTrigFilePath=MsiFilePath
    fprintf(1,['MsiTrigFilePath: ',MsiTrigFilePath]);
    MsiPathTmp=['/export/jesse/data',int2str(ExportDisk),'/',DirStr]
    
    SubDir=int2str(PatConStatus);
    [MkDirStatus,MkDirMessage]=mkdir(MsiPathTmp,SubDir);
    MsiPathTmp=[MsiPathTmp,filesep,SubDir];
    fprintf(1,'\n\n');
    fprintf(1,MkDirMessage);
    SubDir=SubjStr;
    [MkDirStatus,MkDirMessage]=mkdir(MsiPathTmp,SubDir);
    MsiPathTmp=[MsiPathTmp,filesep,SubDir];
    fprintf(1,'\n\n'); 
    fprintf(1,MkDirMessage);
    SubDir=int2str(Session);
    [MkDirStatus,MkDirMessage]=mkdir(MsiPathTmp,SubDir);
    MsiPathTmp=[MsiPathTmp,filesep,SubDir];
    fprintf(1,'\n\n');
    fprintf(1,MkDirMessage);
    SubDir=int2str(Run);
    [MkDirStatus,MkDirMessage]=mkdir(MsiPathTmp,SubDir);
    MsiPathTmp=[MsiPathTmp,filesep,SubDir];
    fprintf(1,'\n\n');
    fprintf(1,MkDirMessage);
    MsiFileTmp=[PatConStr,'.',SubjStr,'.',int2str(Session),'.',int2str(Run)];
    MsiFilePathTmp=[MsiPathTmp,filesep,MsiFileTmp];
    %============NoiseReducer==================
    if NoiseFlag
        fprintf('\n\n');
        fprintf(1,'Reduce noise of file:\n');
        fprintf(1,MsiFilePath);
        fprintf('\n');
        fprintf(1,'Write noise reduced data to file:\n');
        fprintf(1,[MsiFilePath,',n']);
        fprintf('\n');
        if ~exist([MsiFilePath,',n']) | OverwriteStatus
            UnixStr=['noisereducer -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -R MxaA,MyaA,MzaA,GxxA,GyyA,GzxA,GzyA -g -v']
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
        else
            fprintf(1,'\n\n')
            fprintf(1,'Do not do noisereducer since noise reduced file:\n')
            fprintf(1,[MsiFilePath,',n']); fprintf(1,'\n')
            fprintf(1,'already exists.')
        end
        if exist([MsiFilePath,',n']) & DeleteOrigFileStatus          
            UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile]
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
        end
        MsiFile=[MsiFile,',n'];
        MsiFilePath=[MsiFilePath,',n'];
    end
    %============ECG Correction==================
    CoreStatus=0;
    if CorrECGFlag
        %============Invert ECG sensor==================if using noisereducer
        %fprintf('\n\n');
        %fprintf(1,'Invert ECG sensor E31:\n');
        %fprintf(1,MsiFilePath);
        %fprintf('\n');
        %fprintf(1,'Write inverted data to file:\n');
        %fprintf(1,[MsiFilePath,',i']);
        %fprintf('\n');
        %if ~exist([MsiFilePath,',i'])
        %    UnixStr=['inverter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -Tc E31']
        %    [UnixStatus,UnixResult]=unix(UnixStr);
        %   display(UnixResult)
        %else
        %    fprintf(1,'\n\n')
        %    fprintf(1,'Do not do ECG inversion since inverted file:\n')
        %   fprintf(1,[MsiFilePath,',i']); fprintf(1,'\n')
        %    fprintf(1,'already exists.')
        %end
        %if exist([MsiFilePath,',i'])  & DeleteOrigFileStatus          
        %   UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile]
        %   [UnixStatus,UnixResult]=unix(UnixStr);
        %    display(UnixResult)
        %end
        %MsiFile=[MsiFile,',i'];
        %MsiFilePath=[MsiFilePath,',i']; 
        %============ECG Correction==================
        fprintf('\n\n');
        fprintf(1,'ECG correction of file:\n');
        fprintf(1,MsiFilePath);
        fprintf('\n');
        fprintf(1,'Write corrected data to file:\n');
        %fprintf(1,[MsiFilePath,',nsE31']);if using noisereducer
        fprintf(1,[MsiFilePath,',c']);
        fprintf('\n');
        if ~exist([MsiFilePath,',c']) | OverwriteStatus
            %UnixStr=['noisereducer -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -t E31,350uV,0.1,0.3,"minima"']
            UnixStr=['cardiac_remover -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -C E31 -N 10 -H 0.8 -W 0.7 -w 0.2']
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
            ECGFilePath=[MsiPathTmp,filesep,MsiFileTmp,'.ecg.txt']
            ECGFid=fopen(ECGFilePath,'w');
            fprintf(ECGFid,UnixResult);
            fclose(ECGFid);
            if ~isempty(findstr(UnixStr,'core dumped'))
                CoreStatus=1; 
                fprintf(1,'\n\n')
                fprintf(1,'Core dumped in ECG correction !!!!\n')
                fprintf(1,'Continue with noise corrected file.')
                Message=char('Warning:,');
                Message=char(Message,'');
	            Message=char(Message,'Core dumped in ECG correction of file:');
	            Message=char(Message,'');
	            Message=char(Message,[MsiFilePath]);
	            Message=char(Message,'');
                Message=char(Message,'Continue without ECG correction.');
	            hmsgbox=msgbox(Message,'Info','warn'); 
            else
                [PeakVec,DiffVec]=AnaEcg(ECGFilePath);
                ECGFilePath=[MsiPathTmp,filesep,MsiFileTmp,'.ecg'];
                SaveAscii(PeakVec',ECGFilePath); 
            end
        else
            fprintf(1,'\n\n')
            fprintf(1,'Do not do ECG correction since corrected file:\n')
            fprintf(1,[MsiFilePath,',c']); fprintf(1,'\n')
            fprintf(1,'already exists.')
        end
        if exist([MsiFilePath,',c'])  & DeleteOrigFileStatus          
            UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile]
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
        end
        if ~CoreStatus
            MsiFile=[MsiFile,',c'];
            MsiFilePath=[MsiFilePath,',c']; 
        end
    end
    %============Filterer fbp1.5-50Hz,o==================
    if FilterFlag
        FilterStr1='bp1.5-50Hz';
        FilterExt1=[',f',FilterStr1,',o'];
    
        fprintf(1,'\n\n')
        fprintf(1,'Filter file:\n');
        fprintf(1,MsiFilePath);
        fprintf('\n');
        fprintf(1,['using filter: ',FilterStr1,'\n']);
        fprintf(1,'Write filtered data to file:\n');
        fprintf(1,[MsiFilePath,FilterExt1]);
        fprintf('\n');
    
        if ~exist([MsiFilePath,FilterExt1]) | OverwriteStatus
            UnixStr=['flt_help -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -f ',FilterStr1];
            [UnixStatus,UnixResult]=unix(UnixStr);
            fprintf(1,'\n\n')
            fprintf(1,UnixResult)
        else
            fprintf(1,'\n\n')
            fprintf(1,'Do not do filterer since filtered file:\n')
            fprintf(1,[MsiFilePath,FilterExt1]); fprintf(1,'\n')
            fprintf(1,'already exists.')
        end       
        if exist([MsiFilePath,FilterExt1]) & DeleteNoiseFileStatus          
            UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile']
        end  
        %============Filterer bp1-20Hz-678-2==================
        FilterStatus=0
        if FilterStatus
            FilterStr2='bp1-20Hz-678-2';
            FilterExt2=[',f',FilterStr2,',o'];
            fprintf(1,'\n\n')
            fprintf(1,'Filter file:\n');
            fprintf(1,MsiFilePath);
            fprintf('\n');
            fprintf(1,['using filter: ',FilterStr2,'\n']);
            fprintf(1,'Write filtered data to file:\n');
            fprintf(1,[MsiFilePath,FilterExt2]);
            fprintf('\n');
            if ~exist([MsiFilePath,FilterExt2]) | OverwriteStatus
                UnixStr=['flt_help -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -f ',FilterStr2];
               [UnixStatus,UnixResult]=unix(UnixStr);
                fprintf(1,'\n\n')
                fprintf(1,UnixResult)
            else
                fprintf(1,'\n\n')
                fprintf(1,'Do not do filterer since filtered file:\n')
                fprintf(1,[MsiFilePath,FilterExt2]); fprintf(1,'\n')
                fprintf(1,'already exists.')
            end  
        end        
        MsiFile=[MsiFile,FilterExt1];
        MsiFilePath=[MsiPath,filesep,MsiFile];
    end
    %========================================
    %============create_set==================
    if MergeStatus==0 | MergeStatus==1
        MsiFilePathTmp=[MsiPathTmp,filesep,MsiFileTmp];
        fprintf(1,'\n\n')
        fprintf(1,'Create set of file %g:\n',FileInd)
        fprintf(1,'%s\n',MsiFile);
        fprintf(1,'and write set to file:\n')
        fprintf(1,'%s\n',[MsiFilePathTmp,'.set']);
        UnixStr=['create_set -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' > ',MsiFilePathTmp,'.set'];
        [UnixStatus,UnixResult]=unix(UnixStr);
        fprintf(1,'\n\n')
        fprintf(1,UnixResult)  
        %==============exp2besaasc==================
        fprintf(1,'\n\n')
        fprintf(1,'Exp2BesaAsc of file %g:\n')
        fprintf(1,'%s\n',MsiFile);
        fprintf(1,'BaseFilePath:\n')
        fprintf(1,'%s\n',MsiFilePathTmp);
        UnixStr=['exp2BESAasc -n -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' ',MsiFilePathTmp];
        [UnixStatus,UnixResult]=unix(UnixStr);
        fprintf(1,'\n\n')
        fprintf(1,UnixResult) 
        %==============TransMsiContSess=============
        fprintf(1,'\n\n')
        fprintf(1,'TransMsiContSessJens of file %g:\n')
        fprintf(1,'%s\n',MsiFilePath);
        fprintf(1,'Write files to base:\n')
        fprintf(1,'%s\n',[MsiFilePathTmp]);
        %   [MsiFilePath,SetFilePath,SesFilePath,ConFilePath,ParaVec,MEGSensorPosMat,EEGSensorPosMat,MEGSensorNameVec,EEGSensorNameVec,MEGSensorIndexVec,EEGSensorIndexVec]=...
        %   TransMsiContSessJens(MsiFilePath,MsiFilePathTmp,PreTrig,PostTrig,ReTrig,SpecCondVec,NStep,NDefTrig,Session)
        [NonUse,SetFilePath,SesFilePath,ConFilePath,RespFilePath]=TransMsiContSessJens(MsiFilePath,MsiFilePathTmp,MsiTrigFilePath,PreTrigInt,PostTrigInt,1,[],[],NDefTrials,Session);
        [AEMFilePath]=CalcAutoEditMEGMat(SesFilePath,[],1,1,135);
    elseif MergeStatus==2 % Merge only
        SesFilePath=[MsiFilePathTmp,'.ses']
        AEMFilePath=[MsiFilePathTmp,'.ses.AEM']
        ConFilePath=[MsiFilePathTmp,'.ses.con']
        RespFilePath=[MsiFilePathTmp,'.res']
    else
        error('Unknown MergeStatus')
    end
    if Session==1
        if NFilesInSessVec(1)==1
            SesFilePathMat1=char(SesFilePath)
            AEMFilePathMat1=char(AEMFilePath)
            ConFilePathMat1=char(ConFilePath)
            RespFilePathMat1=char(RespFilePath)
            PmgFilePath1=[MsiFilePathTmp,'.pmg']
            SfpFilePath1=[MsiFilePathTmp,'.sfp']
            CotFilePath1=[MsiFilePathTmp,'.cot']
        elseif NFilesInSessVec(1)>1
            SesFilePathMat1=char(SesFilePathMat1,SesFilePath)
            AEMFilePathMat1=char(AEMFilePathMat1,AEMFilePath)
            ConFilePathMat1=char(ConFilePathMat1,ConFilePath)
            RespFilePathMat1=char(RespFilePathMat1,RespFilePath)
        end   
    elseif Session==2
        if NFilesInSessVec(2)==1
            SesFilePathMat2=char(SesFilePath)
            AEMFilePathMat2=char(AEMFilePath)
            ConFilePathMat2=char(ConFilePath)
            RespFilePathMat2=char(RespFilePath)            
            PmgFilePath2=[MsiFilePathTmp,'.pmg']
            SfpFilePath2=[MsiFilePathTmp,'.sfp']
            CotFilePath2=[MsiFilePathTmp,'.cot']
        elseif NFilesInSessVec(2)>1
            SesFilePathMat2=char(SesFilePathMat2,SesFilePath)
            AEMFilePathMat2=char(AEMFilePathMat2,AEMFilePath)
            ConFilePathMat2=char(ConFilePathMat2,ConFilePath)
            RespFilePathMat2=char(RespFilePathMat2,RespFilePath)
        end  
    end
end
if MergeStatus==1 | MergeStatus==2
    MergePath=['/export/jesse/data',int2str(ExportDisk),'/',DirStr,'/',PatConStr,'/',SubjStr,'/']
    if NFilesInSessVec(1)>1
        MergePath1=[MergePath,'1/']
        SubDir='0';
        [MkDirStatus,MkDirMessage]=mkdir(MergePath1,SubDir);
        MergePath1=[MergePath1,SubDir];
        fprintf(1,'\n\n'); 
        fprintf(1,MkDirMessage);

        MergePmgFilePath1=[MergePath1,'/',PatConStr,'.',SubjStr,'.1.pmg'];
        MergeSfpFilePath1=[MergePath1,'/',PatConStr,'.',SubjStr,'.1.sfp'];
        MergeCotFilePath1=[MergePath1,'/',PatConStr,'.',SubjStr,'.1.cot'];
        [CopyPmgSuccess1,CopyPmgMessage1]=copyfile(PmgFilePath1,MergePmgFilePath1) 
        [CopySfpSuccess1,CopySfpMessage1]=copyfile(SfpFilePath1,MergeSfpFilePath1)
        [CopyCotSuccess1,CopyCotMessage1]=copyfile(CotFilePath1,MergeCotFilePath1)
       
        MergeConFile1=[PatConStr,'.',SubjStr,'.1.ses.con'];
        MergeConFilePath1=[MergePath1,'/',MergeConFile1]
        MergeConFiles(ConFilePathMat1,MergeConFilePath1)
        
        MergeAEMFile1=[PatConStr,'.',SubjStr,'.1.ses.AEM'];
        MergeAEMFilePath1=[MergePath1,'/',MergeAEMFile1]
        MergeAEMFiles(AEMFilePathMat1,MergeAEMFilePath1)    
        
        MergeRespFile1=[PatConStr,'.',SubjStr,'.1.ses.res'];
        MergeRespFilePath1=[MergePath1,'/',MergeRespFile1]
        MergeMatFiles(RespFilePathMat1,MergeRespFilePath1)
        
        MergeSesFile1=[PatConStr,'.',SubjStr,'.1.ses'];
        MergeSesFilePath1=[MergePath1,'/',MergeSesFile1]
        MergeSesFiles(SesFilePathMat1,MergeSesFilePath1)
    end
    if length(NFilesInSessVec)==1; 
        return; 
    end
    if NFilesInSessVec(2)>1 
        MergePath2=[MergePath,'2/']
        SubDir='0';
        [MkDirStatus,MkDirMessage]=mkdir(MergePath2,SubDir);
        MergePath2=[MergePath2,SubDir];
        fprintf(1,'\n\n'); 
        fprintf(1,MkDirMessage);
        
        MergePmgFilePath2=[MergePath2,'/',PatConStr,'.',SubjStr,'.2.pmg'];
        MergeSfpFilePath2=[MergePath2,'/',PatConStr,'.',SubjStr,'.2.sfp'];
        MergeCotFilePath2=[MergePath2,'/',PatConStr,'.',SubjStr,'.2.cot'];
        [CopyPmgSuccess2,CopyPmgMessage2]=copyfile(PmgFilePath2,MergePmgFilePath2) 
        [CopySfpSuccess2,CopySfpMessage2]=copyfile(SfpFilePath2,MergeSfpFilePath2)
        [CopyCotSuccess2,CopyCotMessage2]=copyfile(CotFilePath2,MergeCotFilePath2)
        
        MergeConFile2=[PatConStr,'.',SubjStr,'.2.ses.con'];
        MergeConFilePath2=[MergePath2,'/',MergeConFile2]
        MergeConFiles(ConFilePathMat2,MergeConFilePath2)
        
        MergeAEMFile2=[PatConStr,'.',SubjStr,'.2.ses.AEM'];
        MergeAEMFilePath2=[MergePath2,'/',MergeAEMFile2]
        MergeAEMFiles(AEMFilePathMat2,MergeAEMFilePath2)    
        
        MergeRespFile2=[PatConStr,'.',SubjStr,'.2.ses.res'];
        MergeRespFilePath2=[MergePath2,'/',MergeRespFile2]
        MergeMatFiles(RespFilePathMat2,MergeRespFilePath2)
        
        MergeSesFile2=[PatConStr,'.',SubjStr,'.2.ses'];
        MergeSesFilePath2=[MergePath2,'/',MergeSesFile2]
        MergeSesFiles(SesFilePathMat2,MergeSesFilePath2)
    end
end
return;
