%==================================================================
%==================================================================
clear all;
%
%	BatchPeterSpeedAll.m
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	Markus Junghoefer	[2001]
%
%
%	Function definition
%	
%
%=================================================================

%==================================================================
TRStatus=1;
DefFilePath=SetDefPath('r','*.RAW');
[NNetFiles,RAWFileMat,NonUse,BatchFilePath]=ReadFileNames([],DefFilePath);
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath('w',BatchPath);
%===============FilterNetFile====================================

%Filter 50 Hz LowPass
ch_LowPassFilt=1;
ch_HighPassFilt=0;
SampRate=[];
if ch_LowPassFilt | ch_HighPassFilt
	for FileInd=1:NNetFiles
		[NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RAWFileMat,FileInd);
		[NoUse,NoUse,NoUse,NoUse, ...
		NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, ...
		SampRateTmp,NChan]= ReadRAWHeader(NetFilePath);
		if ~isempty(SampRate)
			 if SampRateTmp~=SampRate
				error('It is not possible to filter in batch mode because of different samp rates in different files !')
			end
		end
		SampRate=SampRateTmp;
	end
end

HighDefFreqsMat=[SampRate 3 0];
HighDefRipMat=[3 45];
LowDefFreqsMat=[SampRate 40 50]; 
LowDefRipMat=[3 45];
ch_ChooseChannelInd=0;
ChanStatusVec=ones(NChan,1);
PlotStatus=0;
ch_AddSubZeros=0;
NZPoints=[];

[ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat] = ...
GetHighLowFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
ch_LowPassFilt,ch_HighPassFilt);

%=============================================================

%===============Transform data file format=======================
[TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20);

%DeleteFileMat(RAWFileMat);

%===============FilterNetFile====================================
[FilterTAWFileMat]=FilterNetFile(TAWFileMat,ch_LowPassFilt,LowB,LowA,...
ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat,...
ch_ChooseChannelInd,ChanStatusVec,PlotStatus,ch_AddSubZeros,NZPoints,TRStatus);

%=============================================================
DeleteFileMat(TAWFileMat);

% [EGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHist(NetFileMat,TRStatus,...
% PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
% NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,DMeanSampleStatus)
for i=1:NNetFiles
	[FilterTAWFile,FilterTAWPath,FilterTAWFilePath]=GetFileNameOfMat(FilterTAWFileMat,i);
	if ~isempty(findstr(FilterTAWFile,'0050.'))
		PreTrig=12;
		PostTrig=13;
	elseif ~isempty(findstr(FilterTAWFile,'0075.'))
		PreTrig=19;
		PostTrig=20;
	elseif ~isempty(findstr(FilterTAWFile,'0100.'))
		PreTrig=24;
		PostTrig=25;
	elseif ~isempty(findstr(FilterTAWFile,'0125.'))
		PreTrig=31;
		PostTrig=32;
	elseif ~isempty(findstr(FilterTAWFile,'0150.'))
		PreTrig=37;
		PostTrig=38;
	elseif ~isempty(findstr(FilterTAWFile,'0200.'))
		PreTrig=49;
		PostTrig=50;
	elseif ~isempty(findstr(FilterTAWFile,'0250.'))
		PreTrig=62;
		PostTrig=63;
	elseif ~isempty(findstr(FilterTAWFile,'0300.'))
		PreTrig=74;
		PostTrig=75;
	elseif ~isempty(findstr(FilterTAWFile,'0500.'))
		PreTrig=124;
		PostTrig=125;
	elseif ~isempty(findstr(FilterTAWFile,'.1000.'))
		PreTrig=249;
		PostTrig=250;
	end
	[FilterEGISFilePath]=TransNetGeoHist(FilterTAWFilePath,TRStatus,PreTrig,PostTrig,1)
	if i==1
		FilterEGISFileMat=char(FilterEGISFilePath);
	else
		FilterEGISFileMat=char(FilterEGISFileMat,FilterEGISFilePath);
	end
end


%===============CalcAutoEditMat ohne avg ref EEG und ohne flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);
[AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,[],0,[],1,[],[],1,8,0,0);

%======Suche nach schlechten Kanaelen ==================================
%FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus);
FindBadChan(AEMFilePathMat,3,1);

%======Suche nach schlechten trials ==================================
% [AWEFileMat]=FindBadChanTrial(FilePathMat,AWELimesFac,BatchStatus);
FindBadChanTrial(AEMFilePathMat,2.5,1);
 
%===============CalcAutoEditMat mit avg ref EEG und mit flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);

[AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,[],1,1,1,[],[],0,8,1,1);

