function [OutFileMat]=CalcAvgDivide(InFileMat,CalcBaseStatus,MinBase,MaxBase,AddFileExt)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	CalcAvgDivide.m
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%	[OutFileMat]=CalcAvgDivide(InFileMat,CalcBaseStatus,MinBase,MaxBase)
%
%
%
%=================================================================
if nargin<5; AddFileExt=[]; end
if nargin<4; MaxBase=[]; end
if nargin<3; MinBase=[]; end
if nargin<2; CalcBaseStatus=[]; end
if nargin<1; InFileMat=[]; end

CalcBaseStatus=0
[CalcBaseStatus]=IfEmptyInputBo('Do you want to subtract a baseline ?',[],CalcBaseStatus,1,1);
if CalcBaseStatus & (isempty(MinBase) | isempty(MaxBase))
	fprintf('\n')
	[NPointsBaseStatus]=IfEmptyInputBo('Do you want to use','the whole interval as baseline ?',[],1,0);
	if NPointsBaseStatus; 
		MinBase=[]; MaxBase=[]; 
	else
		[MinBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MinBase,1,0);
		[MaxBase]=IfEmptyInputVal('Please insert the baseline end point:',[],MaxBase,1,0);
	end
end
[DefFilePath] = SetDefPath(1,'*.at*');
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose pairs of avg files or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

if NFilesIn==0; return; end
if round(NFilesIn./2)~=NFilesIn./2; return; end
if CalcBaseStatus
	FileExt='.div.b';
else
	FileExt='.div';
end
if ~isempty(AddFileExt)
	FileExt=[FileExt,AddFileExt];
end
SetNumber1=[];
for FileInd=1:NFilesIn./2
	
	[InFile1,InPath1,InFilePath1]=GetFileNameOfMat(InFileMat,FileInd.*2-1);
	[InFile2,InPath2,InFilePath2]=GetFileNameOfMat(InFileMat,FileInd.*2);
	Nat1=findstr(InFile1,'.at');
	Nat2=findstr(InFile2,'.at');
	if ~isempty(Nat1); Nat1=Nat1+4; end
	if ~isempty(Nat2); Nat2=Nat2+4; end
	SetNumber1=[];
	SetNumber2=[];
    Nat1
    Nat2
	if ~isempty(Nat1) &  ~isempty(Nat2) & length(InFile1)>=Nat1 & length(InFile2)>=Nat2
		SetNumber1=InFile1(Nat1)-48
		SetNumber2=InFile2(Nat2)-48
	end
    pause
	if ~isnan(SetNumber1) & ~isnan(SetNumber2)
		OutFilePath=[InPath1,InFile1(1:Nat1) '-' InFile2(Nat2)];
		if length(InFile1)>Nat1
			OutFilePath=[OutFilePath,InFile1(Nat1+1:length(InFile1))];
		end
		OutFilePath=[OutFilePath,FileExt];
	else
		OutFilePath=[InFilePath1,FileExt];
	end
	[AvgMat1,File1,Path1,FilePath1,NTrialAvgVec1,StdChanTimeMat1,...
	SampRate1,AvgRef1,Version1,MedMedRawVec1,MedMedAvgVec1,EegMegStatus1,NChanExtra1]=ReadAvgFile(InFilePath1);
	[NChan1,NPoints1]=size(AvgMat1);
	[AvgMat2,File2,Path2,FilePath2,NTrialAvgVec2,StdChanTimeMat2,...
	SampRate2,AvgRef2,Version2,MedMedRawVec2,MedMedAvgVec2,EegMegStatus2,NChanExtra2]=ReadAvgFile(InFilePath2);
	[NChan2,NPoints2]=size(AvgMat2);
	if SampRate1~=SampRate2;
		Message=char('Warning: ');Message=char(Message,'');
		Message=char(Message,'Sampling rates');
		Message=char(Message,'of file');
		Message=char(Message,FilePath1);
		Message=char(Message,'and file');
		Message=char(Message,FilePath2);
		Message=char(Message,'are not identical !');
		hmsgbox=msgbox(Message,'Warning','warn'); uiwait(hmsgbox);
	end
	if AvgRef1~=AvgRef2;
		Message=char('Warning: ');Message=char(Message,'');
		Message=char(Message,'The average ref. status');
		Message=char(Message,'of file');
		Message=char(Message,FilePath1);
		Message=char(Message,'and file');
		Message=char(Message,FilePath2);
		Message=char(Message,'are not identical !');
		hmsgbox=msgbox(Message,'Warning','warn'); uiwait(hmsgbox);
	end
	if EegMegStatus1~=EegMegStatus2;
		Message=char('Warning: ');Message=char(Message,'');
		Message=char(Message,'The MEG/EEG status');
		Message=char(Message,'of file');
		Message=char(Message,FilePath1);
		Message=char(Message,'and file');
		Message=char(Message,FilePath2);
		Message=char(Message,'are not identical !');
		hmsgbox=msgbox(Message,'Warning','warn'); uiwait(hmsgbox);
	end
	if NChanExtra1~=NChanExtra2;
		Message=char('Warning: ');Message=char(Message,'');
		Message=char(Message,'The number of extra channels');
		Message=char(Message,'of file');
		Message=char(Message,FilePath1);
		Message=char(Message,'and file');
		Message=char(Message,FilePath2);
		Message=char(Message,'are not identical !');
		hmsgbox=msgbox(Message,'Warning','warn'); uiwait(hmsgbox);
	end
	NMedMedRawVec1=length(MedMedRawVec1);
	NMedMedRawVec2=length(MedMedRawVec2);
	DiffNNMedMedRawVec=NMedMedRawVec2-NMedMedRawVec1;
	if DiffNNMedMedRawVec~=0
		if DiffNNMedMedRawVec>0
			TmpMedMedRawVec1=zeros(NMedMedRawVec2,1);
			TmpMedMedRawVec1(1:NMedMedRawVec1)=MedMedRawVec1;
			MedMedRawVec1=TmpMedMedRawVec1;
		else
			TmpMedMedRawVec2=zeros(NMedMedRawVec1,1);
			TmpMedMedRawVec2(1:NMedMedRawVec2)=MedMedRawVec2;
			MedMedRawVec2=TmpMedMedRawVec2;
		end
	end
	NMedMedAvgVec1=length(MedMedAvgVec1);
	NMedMedAvgVec2=length(MedMedAvgVec2);
	DiffNNMedMedAvgVec=NMedMedAvgVec2-NMedMedAvgVec1;
	if DiffNNMedMedAvgVec~=0
		if DiffNNMedMedAvgVec>0
			TmpMedMedAvgVec1=zeros(NMedMedAvgVec2,1);
			TmpMedMedAvgVec1(1:NMedMedAvgVec1)=MedMedAvgVec1;
			MedMedAvgVec1=TmpMedMedAvgVec1;
		else
			TmpMedMedAvgVec2=zeros(NMedMedAvgVec1,1);
			TmpMedMedAvgVec2(1:NMedMedAvgVec2)=MedMedAvgVec2;
			MedMedAvgVec2=TmpMedMedAvgVec2;
		end
	end
	[mTmp,nTmp]=size(NTrialAvgVec1);
	if nTmp~=1; NTrialAvgVec1=NTrialAvgVec1'; end
	[mTmp,nTmp]=size(NTrialAvgVec2);
	if nTmp~=1; NTrialAvgVec2=NTrialAvgVec2'; end
	if CalcBaseStatus
		if NPointsBaseStatus
			MinBase=1; 
			MaxBase=NPoints1; 
		end
		fprintf('Subtract baseline interval of points %g - %g.\n\n\n',MinBase,MaxBase);
		[AvgMat1]=CalcBaseline(AvgMat1,MinBase,MaxBase);
		[AvgMat2]=CalcBaseline(AvgMat2,MinBase,MaxBase);
	else
		fprintf('No baseline subtraction.\n\n\n');
	end
	AvgMat=AvgMat1./AvgMat2;
	NTrialAvgVec=(NTrialAvgVec1+NTrialAvgVec2)./2;
	StdChanTimeMat=StdChanTimeMat1./StdChanTimeMat2;
	MedMedRawVec=(MedMedRawVec1+MedMedRawVec2)/2;
	MedMedAvgVec=(MedMedAvgVec1+MedMedAvgVec2)./2;
	SaveAvgFile(OutFilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate1,MedMedRawVec,MedMedAvgVec,EegMegStatus1,NChanExtra2);
	if FileInd==1
		OutFileMat=char(OutFilePath);
	else
		OutFileMat=char(OutFileMat,OutFilePath);
	end
end
return;
