function [OutFileMat]=Calc06Short(InFileMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	CalcAvgDiff.m
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%	[OutFileMat]=CalcAvgDiff(InFileMat,CalcBaseStatus,MinBase,MaxBase)
%
%
%
%=================================================================

if nargin<1; InFileMat=[]; end

[DefFilePath] = SetDefPath(1,'*.at*');
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose avg files or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
FileExt='.n';

for FileInd=1:NFilesIn
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileInd);
	OutFilePath=[InFilePath,FileExt];
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec]=ReadAvgFile(InFilePath);
	[NChan,NPoints]=size(AvgMat);
% 	AvgMat=AvgMat(:,1:NPoints-2); 					%A
% 	StdChanTimeMat=StdChanTimeMat(:,1:NPoints-2);
% 	AvgMat=AvgMat(:,2:NPoints-1); 					%B
% 	StdChanTimeMat=StdChanTimeMat(:,2:NPoints-1);
	AvgMatTmp=zeros(NChan,52);
	StdChanTimeMatTmp=zeros(NChan,52);
	AvgMatTmp(:,1:26)=AvgMat(:,1:26);
	AvgMatTmp(:,27:52)=AvgMat(:,42:67); 
	StdChanTimeMatTmp(:,1:26)=AvgMat(:,1:26);
	StdChanTimeMatTmp(:,27:52)=AvgMat(:,42:67);  	
	SaveAvgFile(OutFilePath,AvgMatTmp,NTrialAvgVec,StdChanTimeMatTmp,SampRate,MedMedRawVec,MedMedAvgVec);
end
return;
