function[GainChanVec,ZeroChanVec]=CalcGainZero(FilePath,NChan,Bits,Range,Gain);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	CalcGainZero.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
%
%=================================================================
if Range==0; Range=1; end
if Bits==0; Bits=12; end
if Gain==0; Gain=1; end

[File,Path]=SepFilePath(FilePath);
LFile=length(File);
GainFilePath=[Path,File(1:LFile-3) '.Gain'];
ZeroFilePath=[Path,File(1:LFile-3) '.Zero'];

Fac=Range./(2.^Bits.*Gain);

[GainChanVec,ZeroChanVec,...
GainYear,GainMonth,GainDay,GainHour,GainMinute,GainSec,...
ZeroYear,ZeroMonth,ZeroDay,ZeroHour,ZeroMinute,ZeroSec]=...
ReadNetGainZero(NChan,GainFilePath,ZeroFilePath);
if length(GainChanVec)~=NChan+1;
	error('length(GainChanVec)~=NChan+1')
else
	GainChanVec=Fac.*GainChanVec(NChan+1)./GainChanVec(1:NChan);
end
if length(ZeroChanVec)~=NChan;
	error('length(ZeroChanVec)~=NChan')
end
return;
