FrontBackStatus=2; %1=Back 2=Front
FilePath=['Paul:Data:EEG:HeadMove:HM01.',int2str(FrontBackStatus),'.hm.mat']
DefFilePath=SetDefPath('r','*.mat');
[NMatFiles,MatFileMat,VersionString,BatchFilePath]=ReadFileNames(FilePath,DefFilePath,'Choose mat file(s) or a batch file:');
[MatFile,MatPath,MatFilePath]=GetFileNameOfMat(MatFileMat,1);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
DataMat=squeeze(ReadNDimData(MatFilePath));
[NTrials,NPoints]=size(DataMat);
ConFilePath=[MatFilePath(1:end-6),'ses.con'];
CondVec=ReadAscii(ConFilePath);
PosIndVec=find(CondVec==1);
NegIndVec=find(CondVec==2);
NeutIndVec=find(CondVec==3);
DataMat=CalcBaseline(DataMat,150,200);
PosMat=DataMat(PosIndVec,:);
NegMat=DataMat(NegIndVec,:);
NeutMat=DataMat(NeutIndVec,:);
GradPosMat=gradient(PosMat);
GradNegMat=gradient(NegMat);
GradGradNeutMat=gradient(GradNeutMat);
GradGradPosMat=gradient(GradPosMat);
GradGradNegMat=gradient(GradNegMat);
GradNeutMat=gradient(NeutMat);
PosMean=mean(PosMat);
NegMean=mean(NegMat);
NeutMean=mean(NeutMat);
GradPosMean=mean(GradPosMat);
GradNegMean=mean(GradNegMat);
GradNeutMean=mean(GradNeutMat);
GradGradPosMean=mean(GradGradPosMat);
GradGradNegMean=mean(GradGradNegMat);
GradGradNeutMean=mean(GradGradNeutMat);
figure
subplot(1,3,1)
plot(PosMean,'b')
hold on
plot(NegMean,'r')
plot(NeutMean,'k')
if FrontBackStatus==1
	axis([1 400 -15000 5000])
else
	axis([1 400 -20000 20000])
end

% subplot(1,3,2)
% plot(GradPosMean,'b')
% hold on
% plot(GradNegMean,'r')
% plot(GradNeutMean,'k')
% if FrontBackStatus==1
% 	axis([1 400 -400 200])
% else
% 	axis([1 400 -100 400])
% end
% 
% subplot(1,3,2)
% plot(GradPosMean,'b')
% hold on
% plot(GradNegMean,'r')
% plot(GradNeutMean,'k')
% if FrontBackStatus==1
% 	axis([1 400 -400 200])
% else
% 	axis([1 400 -100 400])
% end
% 
% subplot(1,3,3)
% plot(GradGradPosMean,'b')
% hold on
% plot(GradGradNegMean,'r')
% plot(GradGradNeutMean,'k')
% if FrontBackStatus==1
% 	axis([1 400 -20 20])
% else
% 	axis([1 400 -20 20])
% end
x=[1:NPoints];
figure

if FrontBackStatus==1
	
	GradStart=225;
	GradEnd=350;
	MaxTake=-100;
	
	[PosMin,PosMinInd]=min(GradPosMat(:,GradStart:GradEnd)');
	TakeVec=find(PosMin<MaxTake);
	PosMin=PosMin(TakeVec);
	PosMinInd=PosMinInd(TakeVec);
	PosMinInd=PosMinInd+GradStart;
	
	[NegMin,NegMinInd]=min(GradNegMat(:,GradStart:GradEnd)');
	TakeVec=find(NegMin<MaxTake);
	NegMin=NegMin(TakeVec);
	NegMinInd=NegMinInd(TakeVec);
	NegMinInd=NegMinInd+GradStart;
	
	[NeutMin,NeutMinInd]=min(GradNeutMat(:,GradStart:GradEnd)');
	TakeVec=find(NeutMin<MaxTake);
	NeutMin=NeutMin(TakeVec);
	NeutMinInd=NeutMinInd(TakeVec);
	NeutMinInd=NeutMinInd+GradStart;
	
	MinMat=zeros(3,50);
	MinMat(1,1:length(PosMin))=PosMin;
	MinMat(2,1:length(NegMin))=NegMin;
	MinMat(3,1:length(NeutMin))=NeutMin;
	MinMat=MinMat'
	MeanMinMat=mean(MinMat)
	StdMinMat=std(MinMat)
	
	MinIndMat=zeros(3,50);
	MinIndMat(1,1:length(PosMinInd))=PosMinInd;
	MinIndMat(2,1:length(NegMinInd))=NegMinInd;
	MinIndMat(3,1:length(NeutMinInd))=NeutMinInd;
	MinIndMat=MinIndMat'
	MeanMinIndMat=mean(MinIndMat)
	StdMinIndMat=std(MinIndMat)
	
	Start=250;
	End=400;
	
	subplot(3,2,1)
	plot(x,PosMat(:,:)')
	axis([Start End -40000 10000])
	
	subplot(3,2,3)
	plot(x,NegMat(:,:)')
	axis([Start End -40000 10000])
	
	subplot(3,2,5)
	plot(x,NeutMat(:,:)')
	axis([Start End -40000 10000])
	
	subplot(3,2,2)
	plot(x,GradPosMat(:,:)')
	hold on
	plot(PosMinInd(:),PosMin(:),'*')
	axis([Start GradEnd -1500 500])
	
	subplot(3,2,4)
	plot(x,GradNegMat(:,:)')
	hold on
	plot(NegMinInd(:),NegMin(:),'*')
	axis([Start GradEnd -1500 500])
	
	subplot(3,2,6)
	plot(x,GradNeutMat(:,:)')
	hold on
	plot(NeutMinInd(:),NeutMin(:),'*')
	axis([Start GradEnd -1500 500])
	
else

	GradStart=275;
	GradEnd=375;
	MinTake=100;
	
	[PosMax,PosMaxInd]=max(GradPosMat(:,GradStart:GradEnd)');
	PosTakeVec=find(PosMax>MinTake);
	PosMax=PosMax(PosTakeVec);
	PosMaxInd=PosMaxInd(PosTakeVec);
	PosMaxInd=PosMaxInd+GradStart;
	
	[NegMax,NegMaxInd]=max(GradNegMat(:,GradStart:GradEnd)');
	NegTakeVec=find(NegMax>MinTake);
	NegMax=NegMax(NegTakeVec);
	NegMaxInd=NegMaxInd(NegTakeVec);
	NegMaxInd=NegMaxInd+GradStart;
	
	[NeutMax,NeutMaxInd]=max(GradNeutMat(:,GradStart:GradEnd)');
	NeutTakeVec=find(NeutMax>MinTake);
	NeutMax=NeutMax(NeutTakeVec);
	NeutMaxInd=NeutMaxInd(NeutTakeVec);
	NeutMaxInd=NeutMaxInd+GradStart;
	
	MaxMat=zeros(3,50);
	MaxMat(1,1:length(PosMax))=PosMax;
	MaxMat(2,1:length(NegMax))=NegMax;
	MaxMat(3,1:length(NeutMax))=NeutMax;
	MaxMat=MaxMat'
	MeanMaxMat=mean(MaxMat)
	StdMaxMat=std(MaxMat)
	
	MaxIndMat=zeros(3,50);
	MaxIndMat(1,1:length(PosMaxInd))=PosMaxInd;
	MaxIndMat(2,1:length(NegMaxInd))=NegMaxInd;
	MaxIndMat(3,1:length(NeutMaxInd))=NeutMaxInd;
	MaxIndMat=MaxIndMat'
	MeanMaxIndMat=mean(MaxIndMat)
	StdMaxIndMat=std(MaxIndMat)
	
	[PosGradMax,PosGradMaxInd]=max(GradGradPosMat(:,GradStart:GradEnd)');
	PosGradTakeVec=find(PosGradMax>MinTake);
	PosGradMax=PosGradMax(PosGradTakeVec);
	PosGradMaxInd=PosGradMaxInd(PosGradTakeVec);
	PosGradMaxInd=PosGradMaxInd+GradStart;
	
	PosGradMax'
	PosGradMaxInd'
	pause
	
	[NegGradMax,NegGradMaxInd]=max(GradGradNegMat(:,GradStart:GradEnd)');
	NegGradTakeVec=find(NegGradMax>MinTake);
	NegGradMax=NegGradMax(NegGradTakeVec);
	NegGradMaxInd=NegGradMaxInd(NegTakeVec);
	NegGradMaxInd=NegGradMaxInd+GradStart;
	
	NegGradMax'
	NegGradMaxInd'
	pause
	
	[NeutGradMax,NeutGradMaxInd]=max(GradGradNeutMat(:,GradStart:GradEnd)');
	NeutGradTakeVec=find(NeutGradMax>MinTake);
	NeutGradMax=NeutGradMax(NeutGradTakeVec);
	NeutGradMaxInd=NeutGradMaxInd(NeutGradTakeVec);
	NeutGradMaxInd=NeutGradMaxInd+GradStart;
	
	NeutGradMax'
	NeutGradMaxInd'
	pause
	
	Start=275;
	End=400;
	subplot(3,3,1)
	plot(x,PosMat(PosTakeVec,:)')
	axis([Start End 0 30000])
	
	subplot(3,3,4)
	plot(x,NegMat(NegTakeVec,:)')
	axis([Start End 0 30000])
	
	subplot(3,3,7)
	plot(x,NeutMat(NeutTakeVec,:)')
	axis([Start End 0 30000])
	
	subplot(3,3,2)
	plot(x,GradPosMat(PosTakeVec,:)')
	hold on
	plot(PosMaxInd,PosMax,'*')
	axis([Start End 0 1750])
	
	subplot(3,3,5)
	plot(x,GradNegMat(NegTakeVec,:)')
	hold on
	plot(NegMaxInd,NegMax,'*')
	axis([Start End 0 1750])
	
	subplot(3,3,8)
	plot(x,GradNeutMat(NeutTakeVec,:)')
	hold on
	plot(NeutMaxInd,NeutMax,'*')
	axis([Start End 0 1750])
	
	subplot(3,3,3)
	plot(x,GradGradPosMat(PosTakeVec,:)')
% 	hold on
% 	plot(PosMaxInd,PosMax,'*')
 	axis([Start End -0 500])
	
	subplot(3,3,6)
	plot(x,GradGradNegMat(NegTakeVec,:)')
% 	hold on
% 	plot(NegMaxInd,NegMax,'*')
 	axis([Start End 0 500])

	
	subplot(3,3,9)
	plot(x,GradGradNeutMat(NeutTakeVec,:)')
% 	hold on
% 	plot(NeutMaxInd,NeutMax,'*')
 	axis([Start End 0 500])
	
end
