function DL=FindFiles(Mask,ParentDir)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<2; ParentDir=[]; end
if nargin<1; Mask=[]; end

%if isempty(Mask); Mask=['*.3.at1-0.db']; end
%if isempty(Mask); Mask=['*.spmT_0002.img']; end
if isempty(Mask); Mask=['*.3.app*']; end
if isempty(ParentDir); ParentDir='L:\MEG\FPP\Flucht\'; end
%if isempty(ParentDir); ParentDir='L:\MEG\FPP\Forensik\'; end
%if isempty(ParentDir); ParentDir='L:\MEG\FPKN\FPK\'; end 
DL=[];
%IndVec=[10:72]
%IndVec=[37 39 18 60 29 32 13 64 56 66 72 45 46 21 30 43 22 48 53 54 55 49 50 52] %NoPTSD+NoDiag
IndVec=[47 42 12 66 16 56 28 63 19 54 59 61 67 36] %PTSD High
%IndVec=[43 10 64 25 17 48 62 52 15 14 45 26 46 44] %PTSD Low
%IndVec=[62 69 36 63 23 28 45 47 42 54 67 35 15 27] %Dep High
%IndVec=[64 44 10 19 52 43 41 46 70 48 18 17 57 25] %Dep Low
%IndVec=[10 11 12 14 15 16 17 19 20 23 24 25 26 27 28 31 33 35 38 41 42 44 47 57 59 61 62 63 67 69 70] %PTSD
for Ind=1:length(IndVec)
    i=IndVec(Ind);
    iStr=int2str(i);
    if i<10
        iStr=['0',iStr];
    end
    for j=1:2
        for k=1:2:5
            Path=[ParentDir,iStr,filesep,int2str(j),'.',int2str(k),filesep]
            D=dir([Path,Mask])
            for k=length(D):-1:1 
                if isempty(DL)
                    DL=char([Path,D(k).name]);
                else
                    DL=char(DL,[Path,D(k).name]);
                end
            end
        end
    end
end